/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.types;

import java.nio.file.Path;

public class ContentTypes {
    public static final String[] TEMPLATE_EXTENSIONS = new String[]{"", ".html", ".md", ".markdown", ".txt"};

    private ContentTypes() {
    }

    public static String get(Path path) {
        switch (ContentTypes.extension(path)) {
            case ".html": 
            case ".md": 
            case ".markdown": {
                return "text/html";
            }
            case ".xml": {
                return "application/xml";
            }
            case ".css": 
            case ".less": {
                return "text/css";
            }
            case ".js": 
            case ".coffee": {
                return "application/javascript";
            }
            case ".zip": {
                return "application/zip";
            }
            case ".gif": {
                return "image/gif";
            }
            case ".jpeg": 
            case ".jpg": {
                return "image/jpeg";
            }
            case ".png": {
                return "image/png";
            }
        }
        return "text/plain";
    }

    public static boolean support_templating(Path path) {
        switch (ContentTypes.extension(path)) {
            case ".txt": 
            case ".md": 
            case ".markdown": 
            case ".html": 
            case ".xml": 
            case ".css": 
            case ".less": {
                return true;
            }
        }
        return false;
    }

    public static boolean is_binary(Path path) {
        switch (ContentTypes.extension(path)) {
            case ".txt": 
            case ".md": 
            case ".markdown": 
            case ".html": 
            case ".xml": 
            case ".css": 
            case ".less": 
            case ".map": 
            case ".js": 
            case ".coffee": {
                return false;
            }
        }
        return true;
    }

    private static String extension(Path path) {
        String filename = path.toString();
        int dotIndex = filename.lastIndexOf(46);
        return dotIndex == -1 ? "" : filename.substring(dotIndex);
    }
}

