/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.YamlFrontMatter;

public class Template {
    private final Path path;

    public Template(String uri) {
        Path existing = Resources.findExistingPath(uri);
        if (existing == null) {
            throw new IllegalArgumentException("Template not found " + uri);
        }
        this.path = existing;
    }

    public String render() {
        return this.render(Model.of());
    }

    public String render(String key, Object value) {
        return this.render(Model.of(key, value));
    }

    public String render(String k1, Object v1, String k2, Object v2) {
        return this.render(Model.of(k1, v1, k2, v2));
    }

    public String render(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return this.render(Model.of(k1, v1, k2, v2, k3, v3));
    }

    public String render(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return this.render(Model.of(k1, v1, k2, v2, k3, v3, k4, v4));
    }

    public String render(Model model) {
        return this.render(model.getKeyValues());
    }

    public String render(Map<String, Object> keyValues) {
        try {
            YamlFrontMatter parsedTemplate = YamlFrontMatter.parse(this.path);
            Map<String, Object> allKeyValues = Template.merge(parsedTemplate.getVariables(), keyValues);
            String content = Compiler.compile(this.path, parsedTemplate.getContent());
            String body = HandlebarsCompiler.INSTANCE.compile(content, allKeyValues);
            String layout = (String)parsedTemplate.getVariables().get("layout");
            if (layout == null) {
                return body;
            }
            return new Template("_layouts/" + layout).render(allKeyValues).replace("[[body]]", body);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    private static Map<String, Object> merge(Map<String, Object> first, Map<String, Object> second) {
        HashMap<String, Object> merged = new HashMap<String, Object>(first);
        merged.putAll(second);
        merged.put("body", "[[body]]");
        return merged;
    }
}

