/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

class SourceMapRoute
implements Route {
    SourceMapRoute() {
    }

    @Override
    public Match apply(String uri, Request request, Response response) throws IOException {
        if (!uri.endsWith(".css.map")) {
            return Match.WRONG_URL;
        }
        Path pathMap = Paths.get(uri, new String[0]);
        Path pathLess = Paths.get(Strings.substringBeforeLast(uri, ".css.map") + ".less", new String[0]);
        if (!Resources.isPublic(pathLess)) {
            return Match.WRONG_URL;
        }
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return Match.WRONG_METHOD;
        }
        String contentType = ContentTypes.get(pathMap);
        String less = Resources.read(pathLess, StandardCharsets.UTF_8);
        String map = Compiler.compile(pathMap, less);
        new Payload(contentType, map).writeTo(response);
        return Match.OK;
    }
}

