/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.codestory.http.payload.Payload;
import net.codestory.http.templating.Template;

public class ErrorPage {
    private final int code;
    private final Exception exception;

    public ErrorPage(int code, Exception exception) {
        this.code = code;
        this.exception = exception;
    }

    public Payload payload() {
        String error = ErrorPage.toString(this.exception);
        String filename = this.filename();
        String html = new Template(filename).render("ERROR", error);
        return new Payload("text/html", html, this.code);
    }

    private String filename() {
        return this.code == 404 ? "404.html" : "500.html";
    }

    private static String toString(Exception error) {
        if (error == null) {
            return "";
        }
        StringWriter string = new StringWriter();
        try (PrintWriter message = new PrintWriter(string);){
            error.printStackTrace(message);
        }
        return ((Object)string).toString();
    }
}

