/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class CoffeeCompiler {
    CoffeeCompiler() {
    }

    public String compile(String source) throws IOException {
        Scriptable globalScope = this.initWithCoffeeScriptScript();
        Context context = Context.enter();
        try {
            Scriptable scope = context.newObject(globalScope);
            scope.setParentScope(globalScope);
            scope.put("coffeeScriptSource", scope, (Object)source);
            String string = (String)context.evaluateString(scope, String.format("CoffeeScript.compile(coffeeScriptSource, %s);", "{bare: true}"), "JCoffeeScriptCompiler", 0, null);
            return string;
        }
        catch (JavaScriptException e) {
            throw new IOException("Unable to compile coffee", e);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * Loose catch block
     */
    private Scriptable initWithCoffeeScriptScript() throws IOException {
        Context context = Context.enter();
        try {
            try (InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream("coffee/coffee-script.js"), StandardCharsets.UTF_8);){
                ScriptableObject globalScope = context.initStandardObjects();
                context.evaluateReader((Scriptable)globalScope, (Reader)reader, "coffee-script.js", 0, null);
                ScriptableObject scriptableObject = globalScope;
                return scriptableObject;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Context.exit();
        }
    }
}

