/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.ltsmin.ltl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automaton.concept.DetOutputAutomaton;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.fsa.impl.CompactDFA;
import net.automatalib.exception.FormatException;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelchecker.ltsmin.LTSminDFA;
import net.automatalib.modelchecker.ltsmin.LTSminLTLParser;
import net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelCheckerLasso;
import net.automatalib.modelchecking.impl.DFALassoImpl;
import net.automatalib.serialization.fsm.parser.FSM2DFAParser;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTSminLTLDFA<I>
extends AbstractLTSminLTL<I, DFA<?, I>, Lasso.DFALasso<I>>
implements ModelCheckerLasso.DFAModelCheckerLasso<I, String>,
LTSminDFA<I, Lasso.DFALasso<I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LTSminLTLDFA.class);
    public static final String LABEL_NAME = "label";
    public static final String LABEL_VALUE = "accept";

    public LTSminLTLDFA(boolean keepFiles, Function<String, I> string2Input, int minimumUnfolds, double multiplier) {
        super(keepFiles, string2Input, minimumUnfolds, multiplier);
    }

    @Override
    protected void verifyFormula(String formula) throws FormatException {
        LTSminLTLParser.requireValidLetterFormula(formula);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Lasso.DFALasso<I> findCounterExample(DFA<?, I> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            CompactDFA dfa = (CompactDFA)FSM2DFAParser.getParser(inputs, this.getString2Input(), (String)LABEL_NAME, (String)LABEL_VALUE).readModel(fsm);
            DFALassoImpl dFALassoImpl = new DFALassoImpl((DetOutputAutomaton)dfa, inputs, this.computeUnfolds(automaton.size()));
            return dFALassoImpl;
        }
        catch (IOException | FormatException e) {
            throw new ModelCheckingException((Exception)e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: '{}'", (Object)fsm.getAbsolutePath());
            }
        }
    }
}

