/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.ltsmin;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Paths;
import net.automatalib.common.setting.AutomataLibProperty;
import net.automatalib.common.setting.AutomataLibSettings;
import net.automatalib.common.util.process.ProcessUtil;
import net.automatalib.modelchecker.ltsmin.LTSminVersion;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LTSminUtil {
    public static final String ETF2LTS_MC;
    public static final String LTSMIN_CONVERT;
    private static final String ETF2LTS_MC_BINARY = "etf2lts-mc";
    private static final String LTSMIN_CONVERT_BINARY = "ltsmin-convert";
    private static final Logger LOGGER;
    private static final String CHECK;
    private static final int VERSION_EXIT = 255;
    private static boolean verbose;
    private static @Nullable LTSminVersion detectedVersion;

    private LTSminUtil() {
    }

    @EnsuresNonNullIf(expression={"detectedVersion"}, result=true)
    public static boolean isInstalled() {
        return detectedVersion != null;
    }

    public static @Nullable LTSminVersion getVersion() {
        return detectedVersion;
    }

    public static boolean supports(LTSminVersion requiredVersion) {
        return LTSminUtil.isInstalled() && detectedVersion.supports(requiredVersion);
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        LTSminUtil.verbose = verbose;
    }

    public static void detectLTSmin() {
        LTSminVersion etf2ltsVersion = LTSminUtil.detectLTSmin(ETF2LTS_MC);
        LTSminVersion ltsminConvertVersion = LTSminUtil.detectLTSmin(LTSMIN_CONVERT);
        if (etf2ltsVersion == null) {
            LOGGER.info(CHECK, (Object)ETF2LTS_MC_BINARY);
        }
        if (ltsminConvertVersion == null) {
            LOGGER.info(CHECK, (Object)LTSMIN_CONVERT_BINARY);
        }
        if (etf2ltsVersion != null && ltsminConvertVersion != null) {
            if (!etf2ltsVersion.equals(ltsminConvertVersion)) {
                LOGGER.warn("Found differing {} version '{}' and {} version '{}'. Choosing the former", new Object[]{ETF2LTS_MC_BINARY, etf2ltsVersion, LTSMIN_CONVERT_BINARY, ltsminConvertVersion});
            }
            detectedVersion = etf2ltsVersion;
        }
    }

    private static @Nullable LTSminVersion detectLTSmin(String bin) {
        String[] commandLine = new String[]{bin, "--version"};
        StringWriter stringWriter = new StringWriter();
        try {
            int exitValue = ProcessUtil.invokeProcess((String[])commandLine, stringWriter::append);
            if (exitValue == 255) {
                return LTSminVersion.parse(stringWriter.toString());
            }
            LOGGER.debug("Command '{} --version' did not exit with {}", (Object)bin, (Object)255);
            return null;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug(String.format("Could not execute command '%s'", bin), (Throwable)e);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(LTSminUtil.class);
        CHECK = "Could not find binary '{}' of the LTSmin installation. LTSmin can be obtained at https://ltsmin.utwente.nl. If you installed LTSmin in a non standard location you can set the property: '" + AutomataLibProperty.LTSMIN_PATH.getPropertyKey() + "'. Setting the $PATH variable works too.";
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String ltsMinPath = settings.getProperty(AutomataLibProperty.LTSMIN_PATH, "");
        ETF2LTS_MC = Paths.get(ltsMinPath, ETF2LTS_MC_BINARY).toString();
        LTSMIN_CONVERT = Paths.get(ltsMinPath, LTSMIN_CONVERT_BINARY).toString();
        verbose = !"false".equalsIgnoreCase(settings.getProperty(AutomataLibProperty.LTSMIN_VERBOSE, Boolean.toString(LOGGER.isDebugEnabled())));
        LTSminUtil.detectLTSmin();
    }
}

