/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.ltsmin;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.collection.CollectionUtil;
import net.automatalib.common.util.process.ProcessUtil;
import net.automatalib.exception.FormatException;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelchecker.ltsmin.LTSmin;
import net.automatalib.modelchecker.ltsmin.LTSminUtil;
import net.automatalib.modelchecker.ltsmin.LTSminVersion;
import net.automatalib.modelchecking.ModelChecker;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLTSmin<I, A, R>
implements ModelChecker<I, A, String, R>,
LTSmin<I, A, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLTSmin.class);
    private final boolean keepFiles;
    private final Function<String, I> string2Input;

    protected AbstractLTSmin(boolean keepFiles, Function<String, I> string2Input) {
        this.keepFiles = keepFiles;
        this.string2Input = string2Input;
        if (!LTSminUtil.supports(this.getMinimumRequiredVersion())) {
            LOGGER.warn("LTSmin binary could not be detected in the correct version");
        }
    }

    protected abstract LTSminVersion getMinimumRequiredVersion(@UnknownInitialization(value=AbstractLTSmin.class) AbstractLTSmin<I, A, R> this);

    protected abstract List<String> getExtraCommandLineOptions();

    protected abstract void verifyFormula(String var1) throws FormatException;

    @Override
    public boolean isKeepFiles() {
        return this.keepFiles;
    }

    @Override
    public Function<String, I> getString2Input() {
        return this.string2Input;
    }

    protected final @Nullable File findCounterExampleFSM(A hypothesis, Collection<? extends I> inputs, String formula) {
        File gcf;
        File ltlFile;
        File etf;
        try {
            this.verifyFormula(formula);
        }
        catch (FormatException fe) {
            throw new ModelCheckingException((Exception)((Object)fe));
        }
        try {
            etf = File.createTempFile("automaton2etf", ".etf");
            try {
                this.automaton2ETF(hypothesis, inputs, etf);
            }
            catch (ModelCheckingException mce) {
                if (!this.keepFiles && !etf.delete()) {
                    AbstractLTSmin.logFileWarning(etf);
                }
                throw mce;
            }
        }
        catch (IOException ioe) {
            throw new ModelCheckingException((Exception)ioe);
        }
        try {
            ltlFile = File.createTempFile("formula", ".ltl");
            try (Writer w = IOUtil.asBufferedUTF8Writer((File)ltlFile);){
                w.write(formula);
            }
            catch (IOException ioe) {
                if (!this.keepFiles && !ltlFile.delete()) {
                    AbstractLTSmin.logFileWarning(ltlFile);
                }
                throw new ModelCheckingException((Exception)ioe);
            }
        }
        catch (IOException ioe) {
            throw new ModelCheckingException((Exception)ioe);
        }
        try {
            gcf = File.createTempFile("etf2gcf", ".gcf");
        }
        catch (IOException ioe) {
            if (!this.keepFiles && !etf.delete()) {
                AbstractLTSmin.logFileWarning(etf);
            }
            throw new ModelCheckingException((Exception)ioe);
        }
        List ltsminCommandLine = CollectionUtil.list((Object)LTSminUtil.ETF2LTS_MC, (Object[])new String[]{etf.getAbsolutePath(), "--ltl=" + ltlFile, "--trace=" + gcf.getAbsolutePath(), "--threads=1", "--ltl-semantics=ltsmin", "--allow-undefined-edges"});
        if (LTSminUtil.isVerbose()) {
            ltsminCommandLine.add("-v");
        }
        ltsminCommandLine.addAll(this.getExtraCommandLineOptions());
        try {
            int ltsminExitValue = AbstractLTSmin.runCommandLine(ltsminCommandLine);
            if (ltsminExitValue == 0) {
                File file = null;
                return file;
            }
            if (ltsminExitValue == 1) {
                int convertExitValue;
                File fsm;
                try {
                    fsm = File.createTempFile("gcf2fsm", ".fsm");
                }
                catch (IOException ioe) {
                    throw new ModelCheckingException((Exception)ioe);
                }
                List convertCommandLine = CollectionUtil.list((Object)LTSminUtil.LTSMIN_CONVERT, (Object[])new String[]{gcf.getAbsolutePath(), fsm.getAbsolutePath(), "--rdwr"});
                if (LTSminUtil.isVerbose()) {
                    convertCommandLine.add("-v");
                }
                if ((convertExitValue = AbstractLTSmin.runCommandLine(convertCommandLine)) != 0) {
                    throw new ModelCheckingException("Could not convert GCF to FSM. Enable debug logging to see LTSmin's debug information.");
                }
                File file = fsm;
                return file;
            }
            throw new ModelCheckingException("Could not model check ETF. Enable debug logging to see LTSmin's debug information.");
        }
        finally {
            if (!this.keepFiles) {
                if (!etf.delete()) {
                    AbstractLTSmin.logFileWarning(etf);
                }
                if (!ltlFile.delete()) {
                    AbstractLTSmin.logFileWarning(ltlFile);
                }
                if (!gcf.delete()) {
                    AbstractLTSmin.logFileWarning(gcf);
                }
            }
        }
    }

    private static int runCommandLine(List<String> commandLine) {
        try {
            LOGGER.debug("Invoking LTSmin binary as: {}", (Object)String.join((CharSequence)" ", commandLine));
            return ProcessUtil.invokeProcess(commandLine, arg_0 -> ((Logger)LOGGER).debug(arg_0));
        }
        catch (IOException | InterruptedException e) {
            throw new ModelCheckingException(e);
        }
    }

    private static void logFileWarning(File file) {
        LOGGER.warn("Could not delete file: '{}'", (Object)file.getAbsolutePath());
    }
}

