package net.automatalib.modelchecker.ltsmin.ltl;

import de.learnlib.tooling.annotation.Generated;
import java.lang.String;
import java.util.Collection;
import java.util.function.Function;

/**
 * A builder for constructing {@link LTSminLTLIO} instances.
 * @param <I> the input type
 * @param <O> the output type
 */
@Generated(
        generator = "de.learnlib.tooling.processor.builder.BuilderProcessor",
        source = "net.automatalib.modelchecker.ltsmin.ltl.LTSminLTLIO"
)
public final class LTSminLTLIOBuilder<I, O> {
    private boolean keepFiles;

    private Function<String, I> string2Input;

    private Function<String, O> string2Output;

    private int minimumUnfolds;

    private double multiplier;

    private Collection<? super O> skipOutputs;

    /**
     * Creates a new builder (and may set default values for some parameters).
     */
    public LTSminLTLIOBuilder() {
        this.keepFiles = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.keepFiles();
        this.minimumUnfolds = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.minimumUnfolds();
        this.multiplier = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.multiplier();
        this.skipOutputs = net.automatalib.modelchecker.ltsmin.ltl.AbstractLTSminLTL.BuilderDefaults.skipOutputs();
    }

    /**
     * Returns the current value for the parameter {@code keepFiles}.
     * @return the current value for the parameter {@code keepFiles}
     */
    public boolean getKeepFiles() {
        return this.keepFiles;
    }

    /**
     * Sets the new value for the parameter {@code keepFiles}.
     * @param keepFiles the new value for the parameter {@code keepFiles}
     */
    public void setKeepFiles(boolean keepFiles) {
        this.keepFiles = keepFiles;
    }

    /**
     * Sets the new value for the parameter {@code keepFiles} and returns {@code this} builder instance.
     * @param keepFiles the new value for the parameter {@code keepFiles}
     * @return the current builder instance
     */
    public LTSminLTLIOBuilder<I, O> withKeepFiles(boolean keepFiles) {
        this.keepFiles = keepFiles;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code string2Input}.
     * @return the current value for the parameter {@code string2Input}
     */
    public Function<String, I> getString2Input() {
        return this.string2Input;
    }

    /**
     * Sets the new value for the parameter {@code string2Input}.
     * @param string2Input the new value for the parameter {@code string2Input}
     */
    public void setString2Input(Function<String, I> string2Input) {
        this.string2Input = string2Input;
    }

    /**
     * Sets the new value for the parameter {@code string2Input} and returns {@code this} builder instance.
     * @param string2Input the new value for the parameter {@code string2Input}
     * @return the current builder instance
     */
    public LTSminLTLIOBuilder<I, O> withString2Input(Function<String, I> string2Input) {
        this.string2Input = string2Input;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code string2Output}.
     * @return the current value for the parameter {@code string2Output}
     */
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    /**
     * Sets the new value for the parameter {@code string2Output}.
     * @param string2Output the new value for the parameter {@code string2Output}
     */
    public void setString2Output(Function<String, O> string2Output) {
        this.string2Output = string2Output;
    }

    /**
     * Sets the new value for the parameter {@code string2Output} and returns {@code this} builder instance.
     * @param string2Output the new value for the parameter {@code string2Output}
     * @return the current builder instance
     */
    public LTSminLTLIOBuilder<I, O> withString2Output(Function<String, O> string2Output) {
        this.string2Output = string2Output;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code minimumUnfolds}.
     * @return the current value for the parameter {@code minimumUnfolds}
     */
    public int getMinimumUnfolds() {
        return this.minimumUnfolds;
    }

    /**
     * Sets the new value for the parameter {@code minimumUnfolds}.
     * @param minimumUnfolds the new value for the parameter {@code minimumUnfolds}
     */
    public void setMinimumUnfolds(int minimumUnfolds) {
        this.minimumUnfolds = minimumUnfolds;
    }

    /**
     * Sets the new value for the parameter {@code minimumUnfolds} and returns {@code this} builder instance.
     * @param minimumUnfolds the new value for the parameter {@code minimumUnfolds}
     * @return the current builder instance
     */
    public LTSminLTLIOBuilder<I, O> withMinimumUnfolds(int minimumUnfolds) {
        this.minimumUnfolds = minimumUnfolds;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code multiplier}.
     * @return the current value for the parameter {@code multiplier}
     */
    public double getMultiplier() {
        return this.multiplier;
    }

    /**
     * Sets the new value for the parameter {@code multiplier}.
     * @param multiplier the new value for the parameter {@code multiplier}
     */
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    /**
     * Sets the new value for the parameter {@code multiplier} and returns {@code this} builder instance.
     * @param multiplier the new value for the parameter {@code multiplier}
     * @return the current builder instance
     */
    public LTSminLTLIOBuilder<I, O> withMultiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    /**
     * Returns the current value for the parameter {@code skipOutputs}.
     * @return the current value for the parameter {@code skipOutputs}
     */
    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    /**
     * Sets the new value for the parameter {@code skipOutputs}.
     * @param skipOutputs the new value for the parameter {@code skipOutputs}
     */
    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    /**
     * Sets the new value for the parameter {@code skipOutputs} and returns {@code this} builder instance.
     * @param skipOutputs the new value for the parameter {@code skipOutputs}
     * @return the current builder instance
     */
    public LTSminLTLIOBuilder<I, O> withSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
        return this;
    }

    /**
     * Creates a new {@link LTSminLTLIO} instance with the configured parameters.
     * @return the created instance
     */
    public LTSminLTLIO<I, O> create() {
        return new LTSminLTLIO<I, O>(keepFiles, string2Input, string2Output, minimumUnfolds, multiplier, skipOutputs);
    }
}
