/*
 * Decompiled with CFR 0.152.
 */
package it.techgap.common.security.rest;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.StringUtils;

public class RestSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private RequestCache requestCache = new HttpSessionRequestCache();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (savedRequest == null) {
            this.clearAuthenticationAttributes(request);
            return;
        }
        String targetUrlParam = this.getTargetUrlParameter();
        if (this.isAlwaysUseDefaultTargetUrl() || targetUrlParam != null && StringUtils.hasText((String)request.getParameter(targetUrlParam))) {
            this.requestCache.removeRequest(request, response);
            this.clearAuthenticationAttributes(request);
            return;
        }
        this.clearAuthenticationAttributes(request);
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

