/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.WebDevice;
import io.webdevice.test.UnitTest;
import io.webdevice.wiring.WebDeviceScope;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class WebDeviceScopeTest
extends UnitTest {
    private WebDeviceScope scope;
    @Mock
    private ApplicationContext mockApplicationContext;
    @Mock
    private ConfigurableApplicationContext mockConfigurableContext;
    @Mock
    private ConfigurableListableBeanFactory mockBeanFactory;
    @Mock
    private WebDevice mockWebDevice;

    @Before
    public void setUp() {
        this.scope = new WebDeviceScope();
    }

    @Test
    public void shouldRegisterAndReturnScope() {
        this.scope = WebDeviceScope.registerScope((ConfigurableListableBeanFactory)this.mockBeanFactory);
        Assertions.assertThat((Object)this.scope).isNotNull();
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.mockBeanFactory)).registerScope("web-device", (Scope)this.scope);
    }

    @Test
    public void shouldCreatePrototypes() {
        ObjectFactory factory = () -> new WebDevice(null);
        Assertions.assertThat((Object)this.scope.get("webdevice.WebDevice", factory)).isNotSameAs(this.scope.get("webdevice.WebDevice", factory));
    }

    @Test
    public void shouldRemovePrototypes() {
        WebDevice device1 = new WebDevice(null);
        WebDevice device2 = new WebDevice(null);
        this.scope.get("webdevice.WebDevice", () -> device1);
        this.scope.get("webdevice.WebDevice", () -> device2);
        Assertions.assertThat((boolean)this.scope.isEmpty()).isFalse();
        List prototypes = (List)this.scope.remove("webdevice.WebDevice");
        Assertions.assertThat((List)prototypes).contains(new Object[]{device1, device2});
        Assertions.assertThat((boolean)this.scope.isEmpty()).isTrue();
    }

    @Test
    public void shouldReturnFalseFromDisposeWhenEmpty() {
        Assertions.assertThat((boolean)this.scope.dispose()).isFalse();
    }

    @Test
    public void shouldReturnFalseFromDisposeWhenNotEmptyButNoWebDevices() {
        this.scope.get("prototype", () -> "Hai");
        Assertions.assertThat((boolean)this.scope.dispose()).isFalse();
    }

    @Test
    public void shouldReturnTrueFromDisposeWhenNotEmptyWithWebDevices() {
        this.scope.get("prototype", () -> "Hai");
        this.scope.get("prototype", () -> this.mockWebDevice);
        Assertions.assertThat((boolean)this.scope.dispose()).isTrue();
    }

    @Test
    public void shouldClearInstancesOnDispose() {
        this.scope.get("prototype", () -> "Hai");
        Assertions.assertThat((boolean)this.scope.isEmpty()).isFalse();
        this.scope.dispose();
        Assertions.assertThat((boolean)this.scope.isEmpty()).isTrue();
    }

    @Test
    public void shouldReleaseWebDeviceOnDispose() {
        this.scope.get("prototype", () -> this.mockWebDevice);
        this.scope.dispose();
        ((WebDevice)Mockito.verify((Object)this.mockWebDevice)).release();
    }

    @Test
    public void shouldNotExtractScopeFromApplicationContextWhenNotConfigurable() {
        this.scope = WebDeviceScope.scope((ApplicationContext)this.mockApplicationContext);
        Assertions.assertThat((Object)this.scope).isNull();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConfigurableContext, this.mockApplicationContext, this.mockBeanFactory});
    }

    @Test
    public void shouldExtractScopeFromApplicationContextWhenConfigurable() {
        BDDMockito.given((Object)this.mockConfigurableContext.getBeanFactory()).willReturn((Object)this.mockBeanFactory);
        BDDMockito.given((Object)this.mockBeanFactory.getRegisteredScope("web-device")).willReturn((Object)new WebDeviceScope());
        this.scope = WebDeviceScope.scope((ApplicationContext)this.mockConfigurableContext);
        Assertions.assertThat((Object)this.scope).isNotNull();
        ((ConfigurableApplicationContext)Mockito.verify((Object)this.mockConfigurableContext)).getBeanFactory();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockConfigurableContext, this.mockApplicationContext});
    }
}

