/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DevicePool;
import io.webdevice.device.WebDevice;
import io.webdevice.support.SimpleDeviceCheck;
import io.webdevice.support.SpringDeviceRegistry;
import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.EnvironmentBasedTest;
import io.webdevice.wiring.Settings;
import io.webdevice.wiring.WebDeviceRegistrar;
import io.webdevice.wiring.WebDeviceScope;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;

public class WebDeviceRegistrarTest
extends EnvironmentBasedTest {
    @Mock
    private AnnotationMetadata mockMetadata;
    @Mock(extraInterfaces={ConfigurableListableBeanFactory.class})
    private BeanDefinitionRegistry mockRegistry;
    @Captor
    private ArgumentCaptor<GenericBeanDefinition> definitionCaptor;

    @After
    public void tearDown() throws Exception {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadata});
    }

    @Test
    public void shouldBindSettingsFromEnvironmentUsingDefaults() throws Exception {
        Settings expected = new Settings().withDefaultDevice(null).withScope(null).withStrict(true).withEager(false).withBaseUrl(null);
        Settings actual = WebDeviceRegistrar.settings((Environment)this.environment);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldBindSettingsFromEnvironmentUsingNonDefaults() throws Exception {
        Settings expected = new Settings().withDefaultDevice("Foo").withScope("web-device").withStrict(false).withEager(true).withBaseUrl(new URL("http://webdevice.io"));
        Settings actual = WebDeviceRegistrar.settings((Environment)this.environmentWith("io/webdevice/wiring/non-defaults.yaml"));
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRegisterSettings() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/scope-only.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition deviceRegistry = (GenericBeanDefinition)this.definitionCaptor.getValue();
        Assertions.assertThat((Object)deviceRegistry).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(Settings.class).getBeanDefinition());
        Assertions.assertThat(deviceRegistry.getInstanceSupplier().get()).isEqualTo((Object)WebDeviceRegistrar.settings((Environment)environment));
    }

    @Test
    public void shouldSkipRegisteringDeviceIfAlreadyDefined() throws Exception {
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml"));
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct")).willReturn((Object)true);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
    }

    @Test
    public void shouldSkipRegisteringPoolForPooledDeviceIfAlreadyDefinedAndAliasPoolWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Provider")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Pool")).willReturn((Object)true);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Direct-Provider"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Pool");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("webdevice.Direct-Pool", "Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition provider = (GenericBeanDefinition)this.definitionCaptor.getValue();
        DeviceDefinition definition = WebDeviceRegistrar.settings((Environment)environment).device("Direct");
        Assertions.assertThat((Object)provider).isEqualTo((Object)definition.build().getBeanDefinition());
    }

    @Test
    public void shouldSkipRegisteringProviderForPooledDeviceIfAlreadyDefinedAndAliasPoolWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Provider")).willReturn((Object)true);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Pool")).willReturn((Object)false);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Pool");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Direct-Pool"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("webdevice.Direct-Pool", "Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition pool = (GenericBeanDefinition)this.definitionCaptor.getValue();
        Assertions.assertThat((Class)pool.getBeanClass()).isSameAs(DevicePool.class);
        Assertions.assertThat((int)pool.getAutowireMode()).isSameAs((Object)3);
        Assertions.assertThat((String)pool.getDestroyMethodName()).isEqualTo("dispose");
        ConstructorArgumentValues values = pool.getConstructorArgumentValues();
        Assertions.assertThat((int)values.getArgumentCount()).isSameAs((Object)3);
        Assertions.assertThat((Object)values.getIndexedArgumentValue(0, String.class).getValue()).isEqualTo((Object)"Direct");
        Assertions.assertThat((Object)values.getIndexedArgumentValue(1, String.class).getValue()).isEqualTo((Object)new RuntimeBeanReference("webdevice.Direct-Provider"));
        Assertions.assertThat((Object)values.getIndexedArgumentValue(2, String.class).getValue()).isInstanceOf(SimpleDeviceCheck.class);
    }

    @Test
    public void shouldRegisterPooledDeviceAndAliasPoolWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Provider")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Pool")).willReturn((Object)false);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Direct-Provider"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Pool");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Direct-Pool"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("webdevice.Direct-Pool", "Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition provider = (GenericBeanDefinition)this.definitionCaptor.getAllValues().get(0);
        DeviceDefinition definition = WebDeviceRegistrar.settings((Environment)environment).device("Direct");
        Assertions.assertThat((Object)provider).isEqualTo((Object)definition.build().getBeanDefinition());
        GenericBeanDefinition pool = (GenericBeanDefinition)this.definitionCaptor.getAllValues().get(1);
        Assertions.assertThat((Class)pool.getBeanClass()).isSameAs(DevicePool.class);
        Assertions.assertThat((int)pool.getAutowireMode()).isSameAs((Object)3);
        Assertions.assertThat((String)pool.getDestroyMethodName()).isEqualTo("dispose");
        ConstructorArgumentValues values = pool.getConstructorArgumentValues();
        Assertions.assertThat((int)values.getArgumentCount()).isSameAs((Object)3);
        Assertions.assertThat((Object)values.getIndexedArgumentValue(0, String.class).getValue()).isEqualTo((Object)"Direct");
        Assertions.assertThat((Object)values.getIndexedArgumentValue(1, String.class).getValue()).isEqualTo((Object)new RuntimeBeanReference("webdevice.Direct-Provider"));
        Assertions.assertThat((Object)values.getIndexedArgumentValue(2, String.class).getValue()).isInstanceOf(SimpleDeviceCheck.class);
    }

    @Test
    public void shouldRegisterUnpooledDeviceAndAliasProviderWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-unpooled-device.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("webdevice.Direct-Provider")).willReturn((Object)false);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("webdevice.Direct-Provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Direct-Provider"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("webdevice.Direct-Provider", "Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition provider = (GenericBeanDefinition)this.definitionCaptor.getValue();
        DeviceDefinition definition = WebDeviceRegistrar.settings((Environment)environment).device("Direct");
        Assertions.assertThat((Object)provider).isEqualTo((Object)definition.build().getBeanDefinition());
    }

    @Test
    public void shouldRegisterSpringDeviceRegistryInConfiguredScope() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/scope-only.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition deviceRegistry = (GenericBeanDefinition)this.definitionCaptor.getValue();
        Assertions.assertThat((Object)deviceRegistry).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(SpringDeviceRegistry.class).setScope("application").setAutowireMode(3).getBeanDefinition());
    }

    @Test
    public void shouldRegisterWebDeviceInConfiguredScope() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/non-defaults.yaml");
        WebDeviceRegistrar registrar = new WebDeviceRegistrar((Environment)environment);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)((ConfigurableListableBeanFactory)this.mockRegistry))).registerScope("web-device", (Scope)new WebDeviceScope());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.Settings"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.DeviceRegistry"), (BeanDefinition)ArgumentMatchers.any());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"webdevice.WebDevice"), (BeanDefinition)this.definitionCaptor.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition webDevice = (GenericBeanDefinition)this.definitionCaptor.getValue();
        Assertions.assertThat((Object)webDevice).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(WebDevice.class).setScope("web-device").addConstructorArgReference("webdevice.DeviceRegistry").setAutowireMode(3).addPropertyValue("baseUrl", (Object)new URL("http://webdevice.io")).addPropertyValue("defaultDevice", (Object)"Foo").addPropertyValue("eager", (Object)Boolean.TRUE).addPropertyValue("strict", (Object)Boolean.FALSE).setInitMethodName("initialize").setDestroyMethodName("release").getBeanDefinition());
    }
}

