/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DeviceProvider;
import io.webdevice.test.UnitTest;
import io.webdevice.wiring.DynamicDependsOn;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DynamicDependsOnTest
extends UnitTest {
    private DynamicDependsOn dependsOn;
    @Mock
    private ConfigurableListableBeanFactory mockBeanFactory;
    @Mock
    private BeanDefinition mockBeanDefinition;

    @Before
    public void setUp() {
        this.dependsOn = new DynamicDependsOn();
    }

    @Test
    public void shouldEstablishDeviceRegistryDependenciesOnDeviceProviders() {
        String[] providers = new String[]{"provider-1", "provider-2"};
        BDDMockito.given((Object)this.mockBeanFactory.getBeanDefinition("webdevice.DeviceRegistry")).willReturn((Object)this.mockBeanDefinition);
        BDDMockito.given((Object)this.mockBeanFactory.getBeanNamesForType(DeviceProvider.class)).willReturn((Object)providers);
        this.dependsOn.postProcessBeanFactory(this.mockBeanFactory);
        ((BeanDefinition)Mockito.verify((Object)this.mockBeanDefinition)).setDependsOn(providers);
    }
}

