/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.support.YamlPropertySourceFactory;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;

public class YamlPropertySourceFactoryTest {
    private EncodedResource encodedResource;
    private YamlPropertySourceFactory factory;

    @Before
    public void setUp() {
        this.encodedResource = new EncodedResource((Resource)new ClassPathResource("application.yaml"));
        this.factory = new YamlPropertySourceFactory();
    }

    @Test
    public void shouldUseSuppliedName() throws IOException {
        PropertySource source = this.factory.createPropertySource("foo", this.encodedResource);
        Assertions.assertThat((String)source.getName()).isEqualTo("foo");
    }

    @Test
    public void shouldUseResourceNameWhenSuppliedNameIsNull() throws IOException {
        PropertySource source = this.factory.createPropertySource(null, this.encodedResource);
        Assertions.assertThat((String)source.getName()).isEqualTo("application.yaml");
    }

    @Test
    public void shouldResolvePropertyValue() throws IOException {
        PropertySource source = this.factory.createPropertySource(null, this.encodedResource);
        Assertions.assertThat((Object)source.getProperty("webdevice.base-url")).isEqualTo((Object)"https://webdevice.io");
    }
}

