/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceNotProvidedException;
import io.webdevice.device.DeviceProvider;
import io.webdevice.device.Devices;
import io.webdevice.support.SpringDeviceRegistry;
import io.webdevice.test.UnitTest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class SpringDeviceRegistryTest
extends UnitTest {
    @Mock
    private BeanFactory mockBeanFactory;
    private SpringDeviceRegistry registry;
    @Mock
    private WebDriver mockWebDriver;
    private Device<WebDriver> device;
    @Mock
    private DeviceProvider<WebDriver> mockProvider;

    @Before
    public void setUp() {
        this.registry = new SpringDeviceRegistry(this.mockBeanFactory);
        this.device = Devices.directDevice((String)"iphone", (WebDriver)this.mockWebDriver);
    }

    @Test(expected=DeviceNotProvidedException.class)
    public void provideShouldRaiseDeviceNotProvidedExceptionWhenProviderNotRegistered() {
        BDDMockito.given((Object)((DeviceProvider)this.mockBeanFactory.getBean("iphone", DeviceProvider.class))).willThrow(new Throwable[]{new NoSuchBeanDefinitionException("iphone")});
        this.registry.provide("iphone");
    }

    @Test
    public void provideShouldReturnDeviceFromProvider() {
        BDDMockito.given((Object)((DeviceProvider)this.mockBeanFactory.getBean("iphone", DeviceProvider.class))).willReturn(this.mockProvider);
        BDDMockito.given((Object)((Device)this.mockProvider.get())).willReturn(this.device);
        Assertions.assertThat((Object)this.registry.provide("iphone")).isSameAs(this.device);
    }

    @Test(expected=DeviceNotProvidedException.class)
    public void releaseShouldRaiseDeviceNotProvidedExceptionWhenProviderNotRegistered() {
        BDDMockito.given((Object)((DeviceProvider)this.mockBeanFactory.getBean("iphone", DeviceProvider.class))).willThrow(new Throwable[]{new NoSuchBeanDefinitionException("iphone")});
        this.registry.release(this.device);
    }

    @Test
    public void releaseShouldReturnDeviceToProvider() {
        BDDMockito.given((Object)((DeviceProvider)this.mockBeanFactory.getBean("iphone", DeviceProvider.class))).willReturn(this.mockProvider);
        this.registry.release(this.device);
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.device);
    }
}

