/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.junit;

import io.webdevice.device.WebDevice;
import io.webdevice.support.EnableYamlBinding;
import io.webdevice.support.YamlPropertySourceFactory;
import io.webdevice.wiring.EnableWebDevice;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@ContextConfiguration
@RunWith(value=SpringRunner.class)
public class WebDeviceScopeIT {
    @Autowired
    private WebDevice browser;

    @Test
    public void shouldUseFirefox() {
        this.browser.use("LocalFirefox");
        this.browser.home();
        this.browser.navigateTo("/tasks");
    }

    @Test
    public void shouldUseChrome() {
        this.browser.use("LocalChrome");
        this.browser.home();
        this.browser.navigateTo("/tasks");
    }

    @Test
    public void shouldUseDefaultDevice() {
        this.browser.useDefault();
        this.browser.home();
        this.browser.navigateTo("/tasks");
    }

    @Configuration
    @EnableWebDevice
    @EnableYamlBinding
    @PropertySource(value={"classpath:io/webdevice/junit/prototype-device.yaml"}, factory=YamlPropertySourceFactory.class)
    public static class Wiring {
    }
}

