/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.junit;

import io.webdevice.device.WebDevice;
import io.webdevice.support.EnableYamlBinding;
import io.webdevice.support.YamlPropertySourceFactory;
import io.webdevice.wiring.EnableWebDevice;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@ContextConfiguration
@RunWith(value=SpringRunner.class)
public class SingletonIT {
    @Autowired
    private WebDevice browser;

    @After
    public void releaseBrowser() {
        this.browser.release();
    }

    @Test
    public void shouldUseFirefox() {
        this.browser.use("LocalFirefox");
        this.browser.home();
        this.browser.navigateTo("/tasks");
    }

    @Test
    public void shouldUseChrome() {
        this.browser.use("LocalChrome");
        this.browser.home();
        this.browser.navigateTo("/tasks");
    }

    @Test
    public void shouldUseDefaultDevice() {
        this.browser.useDefault();
        this.browser.home();
        this.browser.navigateTo("/tasks");
    }

    @Configuration
    @EnableWebDevice
    @EnableYamlBinding
    @PropertySource(value={"classpath:io/webdevice/junit/singleton-device.yaml"}, factory=YamlPropertySourceFactory.class)
    public static class Wiring {
    }
}

