/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.scala.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class TypeHelper {
    public static final Map<String, String> basicToWrapper;

    public static boolean doesTypeRequireConversion(TypeInfo type) {
        return type.getKind() != ClassKind.JSON_OBJECT && type.getKind() != ClassKind.JSON_ARRAY && type.getKind() != ClassKind.ENUM && !type.getName().equals("io.vertx.core.buffer.Buffer");
    }

    public static String convertArgListToString(TypeInfo type, boolean convert, BiFunction<TypeInfo, Boolean, String> conversion) {
        String ret;
        if (type.isParameterized() && !(ret = String.join((CharSequence)", ", ((ParameterizedTypeInfo)type).getArgs().stream().map(arg -> (String)conversion.apply((TypeInfo)arg, convert)).collect(Collectors.toList()))).isEmpty()) {
            return "[" + ret + "]";
        }
        return "";
    }

    public static String convertScalaArgListToString(TypeInfo type, boolean convert) {
        return TypeHelper.convertArgListToString(type, convert, TypeHelper::toScalaType);
    }

    public static String convertJavaArgListToString(TypeInfo type, boolean convert) {
        return TypeHelper.convertArgListToString(type, convert, TypeHelper::toJavaType);
    }

    public static String toScalaWithConversion(String name, TypeInfo type, Collection<TypeParamInfo> typeParams, Collection<? extends TypeParamInfo> methodTypeParams) {
        boolean nullable = type.isNullable();
        ClassKind kind = type.getKind();
        if (kind.basic) {
            if (nullable) {
                return "scala.Option(" + name + ".asInstanceOf[" + TypeHelper.typeNameForPrimitiveScala(type) + "])";
            }
            return name + ".asInstanceOf[" + TypeHelper.typeNameForPrimitiveScala(type) + "]";
        }
        if (kind == ClassKind.THROWABLE) {
            return name;
        }
        if (kind == ClassKind.OBJECT) {
            String ret = name;
            if (type.isVariable()) {
                ret = "toScala[" + type.getName() + "](" + name + ")";
                if (nullable) {
                    ret = "scala.Option(" + ret + ")";
                }
                return ret;
            }
            return ret;
        }
        if (kind == ClassKind.VOID || type.getName().equals("java.lang.Void") || type.getName().equals("void")) {
            return name;
        }
        if (kind == ClassKind.JSON_OBJECT || kind == ClassKind.JSON_ARRAY || kind == ClassKind.ENUM || type.getName().equals("io.vertx.core.buffer.Buffer")) {
            if (nullable) {
                return "scala.Option(" + name + ")";
            }
            return name;
        }
        if (kind == ClassKind.DATA_OBJECT) {
            if (nullable) {
                return "scala.Option(" + name + ").map(" + type.getSimpleName() + "(_))";
            }
            return type.getSimpleName() + "(" + name + ")";
        }
        if (kind == ClassKind.API) {
            String args = TypeHelper.convertScalaArgListToString(type, false);
            if (nullable) {
                return "scala.Option(" + name + ").map(" + Helper.getNonGenericType((String)type.getSimpleName()) + args + "(_))";
            }
            return Helper.getNonGenericType((String)type.getSimpleName()) + args + "(" + name + ")";
        }
        if (kind == ClassKind.HANDLER) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return "{x: " + TypeHelper.toScalaType(parameterizedType.getArg(0), false) + " => " + name + ".handle(" + TypeHelper.toJavaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")}";
        }
        if (kind == ClassKind.ASYNC_RESULT) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return "AsyncResultWrapper[" + TypeHelper.toJavaType(parameterizedType.getArg(0), true) + ", " + TypeHelper.toScalaType(parameterizedType.getArg(0), false) + "](x, a => " + TypeHelper.toScalaWithConversion("a", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
        }
        if (kind.collection) {
            if (kind == ClassKind.LIST) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                String conversion = ".asScala";
                if (parameterizedType.getArg(0).isNullable() && !TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    conversion = conversion + ".map(Option(_))";
                } else if (TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    conversion = conversion + ".map(x => " + TypeHelper.toScalaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
                }
                if (nullable) {
                    return "scala.Option(" + name + ").map(_" + conversion + ")";
                }
                return name + conversion;
            }
            if (kind == ClassKind.SET) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                String conversion = ".asScala";
                if (parameterizedType.getArg(0).isNullable() && !TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    conversion = conversion + ".map(Option(_))";
                } else if (TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    conversion = conversion + ".map(x => " + TypeHelper.toScalaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
                }
                if (nullable) {
                    return "scala.Option(" + name + ").map(_" + conversion + ")";
                }
                return name + conversion;
            }
            if (kind == ClassKind.MAP) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                String conversion = ".asScala";
                if (parameterizedType.getArg(1).isNullable() && !TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(1))) {
                    conversion = conversion + ".mapValues(Option(_))";
                } else if (TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(1))) {
                    conversion = conversion + ".mapValues(x => " + TypeHelper.toScalaWithConversion("x", parameterizedType.getArg(1), typeParams, methodTypeParams) + ")";
                }
                if (nullable) {
                    return "scala.Option(" + name + ").map(x => collection.mutable.Map(x" + conversion + ".toSeq: _*))";
                }
                return "collection.mutable.Map(" + name + conversion + ".toSeq: _*)";
            }
        }
        return "Unknown type for toScalaWithConversion " + type.getName() + " " + kind;
    }

    public static String toScalaType(TypeInfo type, boolean convertTypeParamsToObject) {
        boolean nullable = type.isNullable();
        ClassKind kind = type.getKind();
        String typeName = type.getName();
        if (kind == ClassKind.VOID || typeName.equals("java.lang.Void") || typeName.equals("void")) {
            return "Unit";
        }
        if (kind == ClassKind.OBJECT) {
            if (convertTypeParamsToObject) {
                return TypeHelper.wrapInOptionIfNullable(nullable, "Object");
            }
            if (typeName.contains("Object")) {
                return TypeHelper.wrapInOptionIfNullable(nullable, "AnyRef");
            }
            return TypeHelper.wrapInOptionIfNullable(nullable, typeName);
        }
        if (kind == ClassKind.THROWABLE) {
            return "Throwable";
        }
        if (kind.basic) {
            return TypeHelper.wrapInOptionIfNullable(nullable, TypeHelper.typeNameForPrimitiveScala(type));
        }
        if (kind == ClassKind.DATA_OBJECT) {
            return TypeHelper.wrapInOptionIfNullable(nullable, type.getSimpleName());
        }
        if (kind == ClassKind.LIST) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "scala.collection.mutable.Buffer";
            if (!parameterizedType.getArgs().isEmpty()) {
                ret = ret + "[" + TypeHelper.toScalaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
            }
            return TypeHelper.wrapInOptionIfNullable(nullable, ret);
        }
        if (kind == ClassKind.SET) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "scala.collection.mutable.Set";
            if (!parameterizedType.getArgs().isEmpty()) {
                ret = ret + "[" + TypeHelper.toScalaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
            }
            return TypeHelper.wrapInOptionIfNullable(nullable, ret);
        }
        if (kind == ClassKind.MAP) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "scala.collection.mutable.Map";
            if (!parameterizedType.getArgs().isEmpty()) {
                ret = ret + "[" + TypeHelper.toScalaType(parameterizedType.getArg(0), convertTypeParamsToObject) + ", " + TypeHelper.toScalaType(parameterizedType.getArg(1), convertTypeParamsToObject) + "]";
            }
            return TypeHelper.wrapInOptionIfNullable(nullable, ret);
        }
        if (kind == ClassKind.HANDLER) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return "Handler[" + TypeHelper.toScalaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
        }
        if (kind == ClassKind.FUNCTION) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String type1 = TypeHelper.toScalaType(parameterizedType.getArg(0), convertTypeParamsToObject);
            String type2 = TypeHelper.toScalaType(parameterizedType.getArg(1), convertTypeParamsToObject);
            String ret = type1.equals("Unit") ? "() => " + type2 : type1 + " => " + type2;
            return TypeHelper.wrapInOptionIfNullable(nullable, ret);
        }
        if (kind == ClassKind.JSON_OBJECT || kind == ClassKind.JSON_ARRAY || kind == ClassKind.ENUM || typeName.equals("io.vertx.core.buffer.Buffer")) {
            return TypeHelper.wrapInOptionIfNullable(nullable, typeName);
        }
        if (kind == ClassKind.ASYNC_RESULT) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "AsyncResult";
            ret = !parameterizedType.getArgs().isEmpty() ? ret + "[" + TypeHelper.toScalaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]" : ret + "[_]";
            return TypeHelper.wrapInOptionIfNullable(nullable, ret);
        }
        if (kind == ClassKind.API) {
            String ret = Helper.getNonGenericType((String)type.getSimpleName());
            if (type instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                if (parameterizedType.getArgs().isEmpty()) {
                    ret = ret + "[_]";
                } else {
                    String converted = String.join((CharSequence)", ", parameterizedType.getArgs().stream().map(arg -> TypeHelper.toScalaType(arg, convertTypeParamsToObject)).collect(Collectors.toList()));
                    ret = ret + "[" + converted + "]";
                }
            } else if (typeName.contains("io.vertx.core.Future")) {
                ret = ret + "[_]";
            }
            return TypeHelper.wrapInOptionIfNullable(nullable, ret);
        }
        if (kind == ClassKind.CLASS_TYPE) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "Class";
            if (parameterizedType.getArgs().isEmpty()) {
                ret = ret + "[_]";
            } else {
                String converted = String.join((CharSequence)", ", parameterizedType.getArgs().stream().map(arg -> TypeHelper.toScalaType(arg, convertTypeParamsToObject)).collect(Collectors.toList()));
                ret = ret + "[" + converted + "]";
            }
            return ret;
        }
        if (kind == ClassKind.OTHER && typeName.equals("java.time.Instant")) {
            return "java.time.Instant";
        }
        return "Unknown type for toScalaType " + typeName + " " + kind;
    }

    public static String toJavaWithConversion(String name, TypeInfo type) {
        return TypeHelper.toJavaWithConversion(name, type, Collections.emptyList(), Collections.emptyList());
    }

    public static String toJavaWithConversion(String name, TypeInfo type, Collection<TypeParamInfo> typeParams, Collection<? extends TypeParamInfo> methodTypeParams) {
        boolean nullable = type.isNullable();
        if (type.getKind().basic) {
            String ret = name + ".asInstanceOf[" + TypeHelper.toJavaType(type, false) + "]";
            if (nullable) {
                ret = name + ".map(x => x.asInstanceOf[" + TypeHelper.toJavaType(type, false) + "]).orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.THROWABLE) {
            String ret = name;
            if (nullable) {
                ret = name + ".map(x => x).orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.OBJECT) {
            String ret = name;
            if (type.isVariable()) {
                ret = nullable ? name + ".map(x => toJava[" + type.getSimpleName() + "](x)).orNull" : "toJava[" + type.getSimpleName() + "](" + name + ")";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.CLASS_TYPE) {
            String ret = "toJavaClass(" + name + ")";
            if (nullable) {
                ret = name + ".map(x => x).orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.VOID || type.getName().equals("java.lang.Void") || type.getName().equals("void")) {
            return name;
        }
        if (type.getKind() == ClassKind.JSON_OBJECT || type.getKind() == ClassKind.JSON_ARRAY || type.getKind() == ClassKind.ENUM || type.getName().equals("io.vertx.core.buffer.Buffer")) {
            String ret = name;
            if (nullable) {
                ret = name + ".map(x => x).orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.DATA_OBJECT) {
            String ret = name + ".asJava";
            if (nullable) {
                ret = name + ".map(" + name + " => " + ret + ").orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.API) {
            String ret = name + ".asJava" + TypeHelper.fromObjectToInstanceOf(type, typeParams, methodTypeParams);
            if (nullable) {
                ret = name + ".map(" + name + " => " + ret + ").orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.HANDLER) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return "{x: " + TypeHelper.toJavaType(parameterizedType.getArg(0), true) + " => " + name + ".handle(" + TypeHelper.toScalaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")}";
        }
        if (type.getKind() == ClassKind.ASYNC_RESULT) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "AsyncResultWrapper[" + TypeHelper.toScalaType(parameterizedType.getArg(0), false) + ", " + TypeHelper.toJavaType(parameterizedType.getArg(0), true) + "](x, a => " + TypeHelper.toJavaWithConversion("a", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
            if (nullable) {
                ret = name + ".map(" + name + " => " + ret + ").orNull";
            }
            return ret;
        }
        if (type.getKind().collection) {
            String ret = name;
            if (nullable) {
                ret = "res";
            }
            if (type.getKind() == ClassKind.LIST) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                if (parameterizedType.getArg(0).isNullable() && !TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    ret = ret + ".map{case Some(x) => x;case None => null}";
                } else if (TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    ret = ret + ".map(x => " + TypeHelper.toJavaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
                }
            } else if (type.getKind() == ClassKind.SET) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                if (parameterizedType.getArg(0).isNullable() && !TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    ret = ret + ".map{case Some(x) => x;case None => null}";
                } else if (TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    ret = ret + ".map(x => " + TypeHelper.toJavaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
                }
            } else if (type.getKind() == ClassKind.MAP) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                if (parameterizedType.getArg(1).isNullable() && !TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(1))) {
                    ret = ret + ".mapValues{case Some(x) => x;case None => null}";
                } else if (TypeHelper.doesTypeRequireConversion(parameterizedType.getArg(0))) {
                    ret = ret + ".mapValues(x => " + TypeHelper.toJavaWithConversion("x", parameterizedType.getArg(1), typeParams, methodTypeParams) + ")";
                }
            }
            ret = ret + ".asJava";
            if (nullable) {
                ret = name + ".flatMap(res => Some(" + ret + ")).orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.FUNCTION) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String executed = name;
            executed = parameterizedType.getArg(0).getKind() == ClassKind.VOID ? executed + "()" : executed + "(" + TypeHelper.toScalaWithConversion("x", parameterizedType.getArg(0), typeParams, methodTypeParams) + ")";
            executed = TypeHelper.toJavaWithConversion(executed, parameterizedType.getArg(1), typeParams, methodTypeParams);
            String ret = "{x: " + TypeHelper.toJavaType(parameterizedType.getArg(0), true) + " => " + executed + "}";
            if (nullable) {
                ret = name + ".map(" + name + " => " + ret + ").orNull";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.OTHER && type.getName().equals("java.time.Instant")) {
            return name + ".asInstanceOf[java.time.Instant]";
        }
        return "Unknown type for toJavaWithConversion " + type.getName() + " " + type.getKind();
    }

    public static String toJavaType(TypeInfo type, boolean convertTypeParamsToObject) {
        if (type.getKind().basic) {
            return basicToWrapper.containsKey(type.getName()) ? basicToWrapper.get(type.getName()) : type.getName();
        }
        if (type.getKind() == ClassKind.THROWABLE || type.getKind() == ClassKind.VOID || type.getKind() == ClassKind.JSON_OBJECT || type.getKind() == ClassKind.JSON_ARRAY || type.getKind() == ClassKind.ENUM || type.getName().equals("java.lang.Void") || type.getName().equals("void") || type.getName().equals("io.vertx.core.buffer.Buffer")) {
            return type.getSimpleName();
        }
        if (type.getKind() == ClassKind.OBJECT) {
            if (convertTypeParamsToObject) {
                return "Object";
            }
            return type.getSimpleName();
        }
        if (type.getKind() == ClassKind.DATA_OBJECT) {
            return "J" + type.getSimpleName();
        }
        if (type.getKind() == ClassKind.API) {
            String ret = "J" + Helper.getNonGenericType((String)type.getSimpleName());
            if (type.isParameterized()) {
                ret = ret + TypeHelper.convertJavaArgListToString(type, convertTypeParamsToObject);
            } else if (!type.getRaw().getParams().isEmpty()) {
                String args = String.join((CharSequence)", ", type.getRaw().getParams().stream().map(v -> "Object").collect(Collectors.toList()));
                ret = ret + "[" + args + "]";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.CLASS_TYPE) {
            String ret = type.getSimpleName();
            String args = TypeHelper.convertJavaArgListToString(type, convertTypeParamsToObject);
            return ret + "[" + args + "]";
        }
        if (type.getKind() == ClassKind.HANDLER) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return "Handler[" + TypeHelper.toJavaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
        }
        if (type.getKind().collection) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String ret = "";
            if (type.getKind() == ClassKind.LIST) {
                ret = ret + "java.util.List[" + TypeHelper.toJavaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
            } else if (type.getKind() == ClassKind.SET) {
                ret = ret + "java.util.Set[" + TypeHelper.toJavaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
            } else if (type.getKind() == ClassKind.MAP) {
                ret = ret + "java.util.Map[String, " + TypeHelper.toJavaType(parameterizedType.getArg(1), convertTypeParamsToObject) + "]";
            }
            return ret;
        }
        if (type.getKind() == ClassKind.ASYNC_RESULT) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            return Helper.getNonGenericType((String)type.getSimpleName()) + "[" + TypeHelper.toJavaType(parameterizedType.getArg(0), convertTypeParamsToObject) + "]";
        }
        return "Unknown type for toJavaType " + type.getName() + " " + type.getKind();
    }

    public static String typeNameForPrimitiveScala(TypeInfo type) {
        String typeName = type.getName();
        if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
            return "Byte";
        }
        if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
            return "Short";
        }
        if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
            return "Int";
        }
        if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
            return "Long";
        }
        if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
            return "Float";
        }
        if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
            return "Double";
        }
        if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
            return "Boolean";
        }
        if (typeName.equals("char") || typeName.equals("java.lang.Character")) {
            return "Char";
        }
        if (type.getKind() == ClassKind.STRING) {
            return "String";
        }
        return "ERROR typeNameForPrimitiveScala unkown type (" + type + ")";
    }

    public static String wrapInOptionIfNullable(boolean nullable, String expression) {
        if (nullable) {
            return "scala.Option[" + expression + "]";
        }
        return expression;
    }

    public static String fromPropertyInfoToScalaTypeWithConversion(TypeInfo type, String name, PropertyInfo info) {
        ArrayList<TypeParamInfo> typeParams = new ArrayList<TypeParamInfo>();
        ArrayList methodTypeParams = new ArrayList();
        if (info.getKind().isValue()) {
            return TypeHelper.toScalaWithConversion(name, info.getType(), typeParams, methodTypeParams);
        }
        String ret = name + ".asScala";
        if (TypeHelper.doesTypeRequireConversion(type)) {
            if (info.getKind().isList()) {
                ret = ret + ".map(x => " + TypeHelper.toScalaWithConversion("x", info.getType(), typeParams, methodTypeParams) + ")";
            } else if (info.getKind().isSet()) {
                ret = ret + ".map(x => " + TypeHelper.toScalaWithConversion("x", info.getType(), typeParams, methodTypeParams) + ")";
            } else if (info.getKind().isMap()) {
                ret = ret + ".mapValues(x => " + TypeHelper.toScalaWithConversion("x", info.getType(), typeParams, methodTypeParams) + ")";
                ret = "collection.mutable.Map(" + ret + ".toSeq: _*)";
            }
        }
        return ret;
    }

    public static String fromPropertyInfoToScala(PropertyInfo info) {
        if (info.getKind().isValue()) {
            return TypeHelper.toScalaType(info.getType(), false);
        }
        if (info.getKind().isList()) {
            String ret = "scala.collection.mutable.Buffer";
            ret = ret + "[" + TypeHelper.toScalaType(info.getType(), false) + "]";
            return ret;
        }
        if (info.getKind().isSet()) {
            String ret = "scala.collection.mutable.Set";
            ret = ret + "[" + TypeHelper.toScalaType(info.getType(), false) + "]";
            return ret;
        }
        if (info.getKind().isMap()) {
            String ret = "scala.collection.mutable.Map";
            ret = ret + "[String, " + TypeHelper.toScalaType(info.getType(), false) + "]";
            return ret;
        }
        return "ERROR fromPropertyInfoToScala got " + info;
    }

    public static String assembleTypeParams(Collection<TypeParamInfo> typeParams, boolean withTypeParams) {
        if (!typeParams.isEmpty()) {
            String ret = "";
            for (TypeParamInfo param : typeParams) {
                if (!ret.isEmpty()) {
                    ret = ret + ", ";
                }
                ret = ret + param.getName();
                if (!withTypeParams || param.getName().length() != 1) continue;
                ret = ret + ": TypeTag";
            }
            return "[" + ret + "]";
        }
        return "";
    }

    public static String assembleTypeParamsAsObjects(Collection<TypeParamInfo> typeParams) {
        if (!typeParams.isEmpty()) {
            String args = String.join((CharSequence)", ", typeParams.stream().map(v -> "_").collect(Collectors.toList()));
            return "[" + args + "]";
        }
        return "";
    }

    public static String fromObjectToInstanceOf(TypeInfo type) {
        return TypeHelper.fromObjectToInstanceOf(type, Collections.emptyList(), Collections.emptyList());
    }

    public static String fromObjectToInstanceOf(TypeInfo type, Collection<TypeParamInfo> typeParams, Collection<? extends TypeParamInfo> methodTypeParams) {
        String ret = "";
        ret = type.getName().equals("io.vertx.core.Future") && !type.isParameterized() ? (typeParams.isEmpty() && methodTypeParams.isEmpty() ? ret + ".asInstanceOf[JFuture[_]]" : ret + ".asInstanceOf[JFuture[Object]]") : ret + ".asInstanceOf[" + TypeHelper.toJavaType(type, true) + "]";
        return ret;
    }

    public static String escapeIfKeyword(String possibleKeyword) {
        if (TypeHelper.isKeyword(possibleKeyword)) {
            return "`" + possibleKeyword + "`";
        }
        return possibleKeyword;
    }

    public static boolean isKeyword(String possibleKeyword) {
        return possibleKeyword.equals("type") || possibleKeyword.equals("object");
    }

    public static boolean isParentConcrete(Collection<TypeInfo> superTypes) {
        for (TypeInfo stype : superTypes) {
            if (!((ApiTypeInfo)stype.getRaw()).isConcrete()) continue;
            return true;
        }
        return false;
    }

    public static void importForType(String packageName, TypeInfo type, Set<String> ret) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (type.getKind() != ClassKind.JSON_OBJECT && type.getKind() != ClassKind.JSON_ARRAY && type.getKind() != ClassKind.ENUM && !type.getName().equals("io.vertx.core.buffer.Buffer")) break block5;
                            ret.add(type.getRaw().toString());
                            break block6;
                        }
                        if (type.getKind() != ClassKind.API && type.getKind() != ClassKind.DATA_OBJECT) break block7;
                        if (!Helper.getPackageName((String)type.getName()).equals(packageName)) {
                            ret.add(Helper.getNonGenericType((String)type.getRaw().translateName("scala")));
                        }
                        ret.add(TypeHelper.convertTypeToAliasedType(type));
                        break block6;
                    }
                    if (!type.getKind().collection) break block8;
                    ret.add("scala.collection.JavaConverters._");
                    break block6;
                }
                if (type.getKind() != ClassKind.HANDLER) break block9;
                ret.add(type.getRaw().toString());
                if (!type.isParameterized()) break block6;
                for (TypeInfo param : ((ParameterizedTypeInfo)type).getArgs()) {
                    TypeHelper.importForType(packageName, param, ret);
                }
                break block6;
            }
            if (type.getKind() == ClassKind.ASYNC_RESULT) {
                ret.add("io.vertx.lang.scala.AsyncResultWrapper");
                ret.add(type.getRaw().toString());
                if (type.isParameterized()) {
                    for (TypeInfo param : ((ParameterizedTypeInfo)type).getArgs()) {
                        TypeHelper.importForType(packageName, param, ret);
                    }
                }
            }
        }
    }

    public static Set<String> generateImports(TypeInfo type, Collection<TypeInfo> imps, List<MethodInfo> methods) {
        HashSet<String> ret = new HashSet<String>();
        ret.add(TypeHelper.convertTypeToAliasedType(type));
        for (TypeInfo imported : imps) {
            if (imported.getName().contains(".impl.")) continue;
            TypeHelper.importForType(Helper.getPackageName((String)type.getName()), imported, ret);
        }
        for (MethodInfo method : methods) {
            for (ParamInfo param : method.getParams()) {
                TypeHelper.importForType(Helper.getPackageName((String)type.getName()), param.getType(), ret);
            }
        }
        return ret;
    }

    public static String convertTypeToAliasedType(TypeInfo type) {
        return Helper.getPackageName((String)Helper.getNonGenericType((String)type.getName())) + ".{" + Helper.getNonGenericType((String)type.getSimpleName()) + " => J" + Helper.getNonGenericType((String)type.getSimpleName()) + "}";
    }

    public static boolean skipMethod(MethodInfo method) {
        return method.getName().equals("addInterceptor") || method.getName().equals("removeInterceptor");
    }

    public static List<MethodInfo> findBasicMethods(List<MethodInfo> methods) {
        return methods.stream().filter(method -> !method.isFluent() && !method.isCacheReturn() && !method.isStaticMethod() && !method.isDefaultMethod() && !TypeHelper.skipMethod(method)).collect(Collectors.toList());
    }

    public static List<MethodInfo> findDefaultMethods(List<MethodInfo> methods) {
        return methods.stream().filter(method -> method.isDefaultMethod() && !TypeHelper.skipMethod(method) && !method.isFluent() && !method.isCacheReturn()).collect(Collectors.toList());
    }

    public static List<MethodInfo> findFluentMethods(List<MethodInfo> methods) {
        return methods.stream().filter(method -> method.isFluent() && !TypeHelper.skipMethod(method) && !method.isCacheReturn()).collect(Collectors.toList());
    }

    public static List<MethodInfo> findCacheReturnMethods(List<MethodInfo> methods) {
        return methods.stream().filter(method -> method.isCacheReturn() && !TypeHelper.skipMethod(method)).collect(Collectors.toList());
    }

    public static List<MethodInfo> findFutureMethods(List<MethodInfo> methods) {
        return methods.stream().filter(method -> TypeHelper.shouldMethodReturnAFuture(method) && !TypeHelper.skipMethod(method)).collect(Collectors.toList());
    }

    public static boolean isAsyncResultHandler(TypeInfo type) {
        return type.getKind() == ClassKind.HANDLER && ((ParameterizedTypeInfo)type).getArg(0).getKind() == ClassKind.ASYNC_RESULT;
    }

    public static boolean isLastParamAsyncResultHandler(MethodInfo method) {
        int size = method.getParams().size();
        return TypeHelper.isAsyncResultHandler(method.getParam(size - 1).getType());
    }

    public static boolean isMethodNeedsOverride(String callingClassName, MethodInfo method) {
        if (method.getName().equals("toString") && method.getParams().isEmpty()) {
            return true;
        }
        for (ClassTypeInfo ownerType : method.getOwnerTypes()) {
            if (ownerType.getName().equals(callingClassName)) continue;
            return true;
        }
        return false;
    }

    public static TypeInfo typeOfReturnedFuture(MethodInfo method) {
        return ((ParameterizedTypeInfo)((ParameterizedTypeInfo)method.getParam(method.getParams().size() - 1).getType()).getArg(0)).getArg(0);
    }

    public static boolean shouldMethodReturnAFuture(MethodInfo method) {
        int size = method.getParams().size();
        return size > 0 && TypeHelper.isLastParamAsyncResultHandler(method) && method.getReturnType().getKind() != ClassKind.HANDLER;
    }

    public static String invokeMethod(String target, TypeInfo type, MethodInfo method, Collection<TypeParamInfo> typeParams) {
        if (method.getReturnType().getKind() == ClassKind.OBJECT) {
            String ret = "toScala[" + method.getReturnType().getName() + "](" + TypeHelper.invokeMethodWithoutConvertingReturn(target, type, method, typeParams) + ")";
            if (method.getReturnType().isNullable()) {
                return "scala.Option(" + ret + ")";
            }
            return ret;
        }
        return TypeHelper.toScalaWithConversion(TypeHelper.invokeMethodWithoutConvertingReturn(target, type, method, typeParams), method.getReturnType(), typeParams, method.getTypeParams());
    }

    public static String assembleTypeParamString(MethodInfo method) {
        if (!method.getTypeParams().isEmpty()) {
            String args = String.join((CharSequence)", ", method.getTypeParams().stream().map(v -> "Object").collect(Collectors.toList()));
            return "[" + args + "]";
        }
        return "";
    }

    public static String invokeMethodWithoutConvertingReturn(String target, TypeInfo type, MethodInfo method, Collection<TypeParamInfo> typeParams) {
        String paramString = String.join((CharSequence)", ", method.getParams().stream().map(param -> TypeHelper.toJavaWithConversion(TypeHelper.escapeIfKeyword(param.getName()), param.getType(), typeParams, method.getTypeParams())).collect(Collectors.toList()));
        return target + "." + TypeHelper.escapeIfKeyword(method.getName()) + TypeHelper.assembleTypeParamString(method) + "(" + paramString + ")";
    }

    public static String invokeMethodAndUseProvidedHandler(String target, TypeInfo type, MethodInfo method, Collection<TypeParamInfo> typeParams, String handler) {
        String typeParamString = TypeHelper.assembleTypeParamString(method);
        String paramString = "";
        for (ParamInfo param : method.getParams()) {
            if (!paramString.equals("")) {
                paramString = paramString + ", ";
            }
            if (TypeHelper.isAsyncResultHandler(param.getType())) {
                paramString = paramString + handler;
                continue;
            }
            paramString = paramString + TypeHelper.toJavaWithConversion(TypeHelper.escapeIfKeyword(param.getName()), param.getType(), typeParams, method.getTypeParams());
        }
        return target + "." + TypeHelper.escapeIfKeyword(method.getName()) + typeParamString + "(" + paramString + ")";
    }

    public static String invokeStaticMethod(String target, TypeInfo type, MethodInfo method) {
        List<TypeParamInfo> typeParams = Collections.emptyList();
        String paramString = String.join((CharSequence)", ", method.getParams().stream().map(param -> TypeHelper.toJavaWithConversion(TypeHelper.escapeIfKeyword(param.getName()), param.getType(), typeParams, method.getTypeParams())).collect(Collectors.toList()));
        String typeParamString = "";
        if (!method.getTypeParams().isEmpty()) {
            typeParamString = String.join((CharSequence)", ", method.getTypeParams().stream().map(param -> "Object").collect(Collectors.toList()));
            typeParamString = "[" + typeParamString + "]";
        }
        return TypeHelper.toScalaWithConversion(target + "." + TypeHelper.escapeIfKeyword(method.getName()) + typeParamString + "(" + paramString + ")", method.getReturnType(), typeParams, method.getTypeParams());
    }

    public static List<TypeParamInfo> removeLastParam(List<TypeParamInfo> params) {
        ArrayList<TypeParamInfo> ret = new ArrayList<TypeParamInfo>(params);
        ret.remove(params.size() - 1);
        return ret;
    }

    public static String createNameForMethodReturningAFuture(MethodInfo method) {
        String methodName = method.getName();
        if (methodName.endsWith("Handler")) {
            methodName = methodName.substring(0, methodName.length() - 7);
        }
        methodName = methodName + "Future";
        return TypeHelper.escapeIfKeyword(methodName);
    }

    public static String methodDoc(TypeInfo type, MethodInfo method, String indentation, boolean future) {
        String doc = "";
        String commentedIndentation = indentation;
        commentedIndentation = commentedIndentation + " *";
        if (method.getDoc() != null) {
            TypeInfo returnType = method.getReturnType();
            Text returnDescription = method.getReturnDescription();
            doc = doc + indentation;
            doc = doc + "/**\n";
            if (future) {
                doc = doc + commentedIndentation;
                doc = doc + " Like [[" + method.getName() + "]] but returns a [[scala.concurrent.Future]] instead of taking an AsyncResultHandler.\n";
            } else {
                doc = doc + TypeHelper.renderDoc(type, commentedIndentation, method.getDoc());
                for (ParamInfo param : method.getParams()) {
                    if (param.getDescription() == null) continue;
                    doc = doc + commentedIndentation;
                    doc = doc + " @param " + param.getName() + " ";
                    doc = doc + TypeHelper.convertLink(param.getDescription());
                    if (param.getType().getKind() == ClassKind.DATA_OBJECT) {
                        doc = doc + " see " + TypeHelper.renderDataObjectHtmlLink(type, param.getType());
                    }
                    doc = doc.replace("{@code ", "`").replace("{@literal", "`").replace("@literal{", "`").replace("@code{", "`").replace("}", "`");
                    doc = doc + "\n";
                }
                if (!returnType.getName().equals("void") && returnDescription != null) {
                    doc = doc + commentedIndentation;
                    doc = doc + " @return ";
                    doc = doc + TypeHelper.convertLink(returnDescription);
                    if (returnType.getKind() == ClassKind.DATA_OBJECT) {
                        doc = doc + "see " + TypeHelper.renderDataObjectHtmlLink(type, returnType);
                    }
                    doc = doc.replace("{@code ", "`").replace("{@literal", "`").replace("@literal{", "`").replace("@code{", "`").replace("}", "`");
                    doc = doc + "\n";
                }
            }
            doc = doc + commentedIndentation;
            doc = doc + "/";
        }
        return doc;
    }

    public static String renderDataObjectHtmlLink(TypeInfo type, TypeInfo dataObjectType) {
        StringBuilder link = new StringBuilder();
        for (String name : Case.QUALIFIED.parse(type.getRaw().getPackageName())) {
            link.append("../");
        }
        link.append("../../../cheatsheet/").append(dataObjectType.getSimpleName()).append(".html");
        return "<a href=\"" + link + "\">" + dataObjectType.getSimpleName() + "</a>";
    }

    public static String convertLink(Text doc) {
        String linkText = "{@link";
        String transformedDoc = "";
        int start = 0;
        int index = doc.getValue().indexOf(linkText);
        while (index >= 0) {
            int end = doc.getValue().indexOf("}", index);
            transformedDoc = transformedDoc + doc.getValue().substring(start, index) + TypeHelper.toScalaDocType(doc.getValue().substring(index + 1 + linkText.length(), end));
            start = end + 1;
            index = doc.getValue().indexOf(linkText, start);
        }
        transformedDoc = transformedDoc + doc.getValue().substring(start);
        return transformedDoc;
    }

    public static String toScalaDocType(String type) {
        if (type.contains("AsyncResult")) {
            return "io.vertx.lang.scala.AsyncResult";
        }
        if (type.equals("void") || type.equals("java.lang.Void")) {
            return "Unit";
        }
        if (type.equals("Object") || type.equals("java.lang.Object")) {
            return "AnyRef";
        }
        if (type.equals("Throwable") || type.equals("java.lang.Throwable")) {
            return "Throwable";
        }
        if (type.equals("String") || type.equals("java.lang.String")) {
            return "String";
        }
        if (type.equals("byte") || type.equals("java.lang.Byte")) {
            return "Byte";
        }
        if (type.equals("short") || type.equals("java.lang.Short")) {
            return "Short";
        }
        if (type.equals("int") || type.equals("java.lang.Integer")) {
            return "Int";
        }
        if (type.equals("long") || type.equals("java.lang.Long")) {
            return "Long";
        }
        if (type.equals("float") || type.equals("java.lang.Float")) {
            return "Float";
        }
        if (type.equals("double") || type.equals("java.lang.Double")) {
            return "Double";
        }
        if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            return "Boolean";
        }
        if (type.equals("char") || type.equals("java.lang.Character")) {
            return "Char";
        }
        if (type.equals("List") || type.equals("java.util.List")) {
            return "scala.collection.immutable.List";
        }
        if (type.equals("Set") || type.equals("java.util.Set")) {
            return "scala.collection.immutable.Set";
        }
        if (type.equals("Map") || type.equals("java.util.Map")) {
            return "scala.collection.immutable.Map";
        }
        if (type.equals("Handler") || type.equals("io.vertx.core.Handler")) {
            return "scala-function";
        }
        if (type.contains("io.vertx") && !type.endsWith("Exception")) {
            return TypeHelper.convertToScalaNotation(type).replace("io.vertx.", "io.vertx.scala.");
        }
        return type;
    }

    public static String convertToScalaNotation(String type) {
        return type.replace("<", "[").replace(">", "]").replace("java.lang.", "");
    }

    public static boolean isAsyncResultHandlerHandler(Element type) {
        return type.toString().contains("io.vertx.core.Handler") && type.toString().contains("io.vertx.core.AsyncResult");
    }

    public static String renderDocLink(TypeInfo type, Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.ENUM) {
                return "[[" + TypeHelper.convertToScalaNotation(rawType.getName()) + "]]";
            }
            if (rawType.getKind() == ClassKind.DATA_OBJECT) {
                if (label.length() == 0) {
                    label = rawType.getSimpleName();
                }
                return TypeHelper.renderDataObjectHtmlLink(type, (TypeInfo)rawType);
            }
            if (type.getKind() == ClassKind.API && !type.getName().equals("io.vertx.core.Handler")) {
                Element elt = link.getTargetElement();
                if (elt.getSimpleName().toString().equals("Verticle")) {
                    return "[[io.vertx.lang.scala.ScalaVerticle]]";
                }
                if (elt.getSimpleName().toString().equals("Handler")) {
                    if (TypeHelper.isAsyncResultHandlerHandler(elt)) {
                        return "[[scala.concurrent.Future]]";
                    }
                    return "scala-function";
                }
                String eltKind = elt.getKind().name();
                String ret = "[[" + rawType.getRaw().translateName("scala");
                if (eltKind.equals("METHOD")) {
                    ret = !elt.getSimpleName().toString().equals("executeBlocking") && ((ExecutableElement)elt).getParameters().size() > 0 && TypeHelper.isAsyncResultHandlerHandler(((ExecutableElement)elt).getParameters().get(((ExecutableElement)elt).getParameters().size() - 1)) ? ret + "#" + elt.getSimpleName().toString() + "Future" : ret + "#" + elt.getSimpleName().toString();
                }
                ret = ret + "]]";
                return ret;
            }
            return "[[" + TypeHelper.toScalaDocType(rawType.getName()) + "]]";
        }
        return null;
    }

    public static String renderDoc(TypeInfo type, String margin, Doc doc) {
        boolean need = true;
        StringBuilder output = new StringBuilder();
        for (Token token : doc.getTokens()) {
            if (need) {
                output.append(margin);
                need = false;
            }
            if (token.isLineBreak()) {
                output.append("\n");
                need = true;
                continue;
            }
            if (token.isText()) {
                output.append(token.getValue());
                continue;
            }
            Tag tag = ((Token.InlineTag)token).getTag();
            if (tag instanceof Tag.Link) {
                String outputLink = TypeHelper.renderDocLink(type, (Tag.Link)tag);
                if (outputLink == null || outputLink.trim().isEmpty()) {
                    outputLink = ((Tag.Link)tag).getLabel();
                }
                if (outputLink == null || outputLink.trim().isEmpty()) {
                    outputLink = ((Tag.Link)tag).getTargetElement().getSimpleName().toString();
                }
                output.append(outputLink);
                continue;
            }
            if (!tag.getName().equals("code")) continue;
            output.append("`").append(tag.getValue().trim().replace("/*", "/\\*")).append("`");
        }
        return output.toString().replace("<p>", "");
    }

    static {
        HashMap<String, String> writable = new HashMap<String, String>();
        writable.put("byte", "java.lang.Byte");
        writable.put("short", "java.lang.Short");
        writable.put("int", "java.lang.Integer");
        writable.put("long", "java.lang.Long");
        writable.put("float", "java.lang.Float");
        writable.put("double", "java.lang.Double");
        writable.put("boolean", "java.lang.Boolean");
        writable.put("char", "java.lang.Character");
        basicToWrapper = Collections.unmodifiableMap(writable);
    }
}

