/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.scala.codegen;

import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.lang.scala.ScalaLang;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import java.beans.Introspector;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public class ScalaDocGenerator
implements DocGenerator {
    private TypeMirrorFactory factory;
    private CodeTranslator translator;
    private ProcessingEnvironment env;

    public void init(ProcessingEnvironment processingEnvironment) {
        this.factory = new TypeMirrorFactory(processingEnvironment.getElementUtils(), processingEnvironment.getTypeUtils());
        this.translator = new CodeTranslator(processingEnvironment);
        this.env = processingEnvironment;
    }

    public String getName() {
        return "scala";
    }

    public String renderSource(ExecutableElement elt, String source) {
        ScalaLang lang = new ScalaLang();
        try {
            return this.translator.translate(elt, (Lang)lang);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        TypeInfo type = null;
        try {
            type = this.factory.create(elt.asType());
        }
        catch (Exception e) {
            System.out.println("Could not resolve doc link for type " + elt.getQualifiedName());
            return null;
        }
        if (type.getKind().equals((Object)ClassKind.ENUM) && ((EnumTypeInfo)type).isGen()) {
            String baselink = null;
            baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "enums.html#" + elt.getSimpleName().toString();
        }
        if (type.getKind().equals((Object)ClassKind.DATA_OBJECT)) {
            String baselink = null;
            baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "dataobjects.html#" + elt.getSimpleName().toString();
        }
        if (type.getKind().equals((Object)ClassKind.API)) {
            ApiTypeInfo api = (ApiTypeInfo)type.getRaw();
            return "../../scaladocs/" + api.translateName("scala").replace('.', '/') + ".html";
        }
        return null;
    }

    public String resolveConstructorLink(ExecutableElement executableElement, Coordinate coordinate) {
        return "todo";
    }

    public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt, coordinate);
        if (link != null) {
            if (link.contains("cheatsheet")) {
                link = link + '#' + Introspector.decapitalize(elt.getSimpleName().toString().substring(3));
            } else {
                StringBuilder anchor = new StringBuilder('#' + elt.getSimpleName().toString() + "(");
                TypeMirror type = elt.asType();
                ExecutableType methodType = (ExecutableType)this.env.getTypeUtils().erasure(type);
                List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
                IntStream.range(0, parameterTypes.size() - 1).forEach(index -> {
                    if (index > 0) {
                        anchor.append(",%20");
                    }
                    String[] splitted = ((TypeMirror)parameterTypes.get(index)).toString().split(" :: ");
                    anchor.append(splitted[splitted.length - 1]);
                });
                anchor.append(')');
                link = link + anchor.toString();
            }
        }
        return link;
    }

    public String resolveFieldLink(VariableElement variableElement, Coordinate coordinate) {
        return "todo";
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        TypeInfo type;
        if (elt.getKind().equals((Object)ElementKind.METHOD) && (type = this.factory.create(elt.getEnclosingElement().asType())).getKind().equals((Object)ClassKind.DATA_OBJECT)) {
            String name = elt.getSimpleName().toString();
            if (name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                name = Introspector.decapitalize(name.substring(3));
            }
            return name;
        }
        return defaultLabel;
    }
}

