/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.scala.codegen;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.vertx.codegen.Case;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeNameTranslator;
import io.vertx.lang.scala.codegen.TypeHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;

public class DataObjectCodeGenerator
extends Generator<Model> {
    public String filename;
    public String templateFilename;
    public Template template;

    public void load(ProcessingEnvironment processingEnv) {
        super.load(processingEnv);
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(DataObjectCodeGenerator.class, "/templates");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            this.template = cfg.getTemplate("dataobject.ftl");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String filename(Model model) {
        if (!((TypeInfo)model.getVars().get("type")).getName().equals("io.vertx.ext.web.handler.sockjs.PermittedOptions")) {
            return "scala/" + model.getModule().translateQualifiedName(model.getFqn(), "scala").replace('.', '/') + ".scala";
        }
        return null;
    }

    public String render(Model model, int index, int size, Map<String, Object> session) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        ClassTypeInfo type = (ClassTypeInfo)model.getVars().get("type");
        Set importedTypes = (Set)model.getVars().get("importedTypes");
        Set superTypes = (Set)model.getVars().get("superTypes");
        vars.putAll(TypeNameTranslator.vars((String)this.name));
        vars.putAll(model.getVars());
        vars.put("typeHelper", new TypeHelper());
        vars.put("className", Helper.getSimpleName((String)type.getName()));
        vars.put("packageName", type.getRaw().translatePackageName("scala"));
        vars.put("imps", this.adjustedImports(type, importedTypes, superTypes));
        vars.put("isAllSuperTypesAbstract", this.isAllSuperTypesAbstract(superTypes));
        vars.putAll(ClassKind.vars());
        vars.putAll(MethodKind.vars());
        vars.putAll(Case.vars());
        StringWriter writer = new StringWriter();
        try {
            this.template.process(vars, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Set<String> adjustedImports(ClassTypeInfo type, Set<TypeInfo> importedTypes, Set<TypeInfo> superTypes) {
        Set<String> imps = TypeHelper.generateImports((TypeInfo)type, importedTypes, Collections.emptyList());
        for (TypeInfo superType : superTypes) {
            imps.remove(superType.getRaw().translatePackageName("scala") + '.' + superType.getSimpleName());
            imps.remove(TypeHelper.convertTypeToAliasedType(superType));
        }
        for (TypeInfo superType : superTypes) {
            imps.add(superType.getRaw().translatePackageName("scala") + ".{" + superType.getSimpleName() + " => Ext" + superType.getSimpleName() + "}");
        }
        imps.add("io.vertx.lang.scala.json.Json._");
        imps.add("io.vertx.core.json.JsonObject");
        imps.add("scala.collection.JavaConverters._");
        return imps;
    }

    public boolean isAllSuperTypesAbstract(Set<TypeInfo> superTypes) {
        return superTypes.stream().map(type -> (DataObjectTypeInfo)type).allMatch(DataObjectTypeInfo::isAbstract);
    }
}

