/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.scala.codegen;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.vertx.codegen.Case;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeNameTranslator;
import io.vertx.lang.scala.codegen.TypeHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;

public class ClassCodeGenerator
extends Generator<Model> {
    public String filename;
    public String templateFilename;
    public Template template;

    public void load(ProcessingEnvironment processingEnv) {
        super.load(processingEnv);
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(ClassCodeGenerator.class, "/templates");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            this.template = cfg.getTemplate("class.ftl");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String filename(Model model) {
        if (!((TypeInfo)model.getVars().get("type")).getName().equals("io.vertx.core.buffer.Buffer")) {
            return "scala/" + model.getModule().translateQualifiedName(model.getFqn(), "scala").replace('.', '/') + ".scala";
        }
        return null;
    }

    public String render(Model model, int index, int size, Map<String, Object> session) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        ClassTypeInfo type = (ClassTypeInfo)model.getVars().get("type");
        Set importedTypes = (Set)model.getVars().get("importedTypes");
        List superTypes = (List)model.getVars().get("superTypes");
        vars.putAll(TypeNameTranslator.vars((String)this.name));
        vars.putAll(model.getVars());
        vars.put("typeHelper", new TypeHelper());
        vars.put("className", Helper.getSimpleName((String)type.getName()));
        vars.put("packageName", type.getRaw().translatePackageName("scala"));
        vars.put("imps", this.adjustedImports(type, importedTypes));
        vars.putAll(ClassKind.vars());
        vars.putAll(MethodKind.vars());
        vars.putAll(Case.vars());
        vars.put("classes", this.classes(superTypes));
        vars.put("abstractClasses", this.abstractClasses(superTypes));
        vars.put("basicMethods", TypeHelper.findBasicMethods((List)vars.get("instanceMethods")));
        vars.put("cacheReturnMethods", TypeHelper.findCacheReturnMethods((List)vars.get("instanceMethods")));
        vars.put("defaultMethods", TypeHelper.findDefaultMethods((List)vars.get("instanceMethods")));
        vars.put("fluentMethods", TypeHelper.findFluentMethods((List)vars.get("instanceMethods")));
        vars.put("futureMethods", TypeHelper.findFutureMethods((List)vars.get("instanceMethods")));
        StringWriter writer = new StringWriter();
        try {
            this.template.process(vars, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Set<String> adjustedImports(ClassTypeInfo type, Set<TypeInfo> importedTypes) {
        Set<String> imps = TypeHelper.generateImports((TypeInfo)type, importedTypes, Collections.emptyList());
        imps.add("io.vertx.lang.scala.HandlerOps._");
        imps.add("scala.reflect.runtime.universe._");
        imps.add("io.vertx.lang.scala.Converter._");
        if (type.getName().equals("io.vertx.ext.web.templ.TemplateEngine")) {
            imps.remove("io.vertx.scala.ext.web.common.template.TemplateEngine");
            imps.add("io.vertx.scala.ext.web.common.template.{TemplateEngine => STemplateEngine}");
            imps.remove("io.vertx.ext.web.common.template.{TemplateEngine => JTemplateEngine}");
        }
        if (type.getName().equals("io.vertx.core.Vertx")) {
            imps.add("io.vertx.lang.scala.ScalaVerticle");
        }
        return imps;
    }

    public List<TypeInfo> classes(Collection<TypeInfo> classTypeInfos) {
        return classTypeInfos.stream().filter(clazz -> ((ApiTypeInfo)clazz.getRaw()).isConcrete()).collect(Collectors.toList());
    }

    public List<TypeInfo> abstractClasses(Collection<TypeInfo> classTypeInfos) {
        return classTypeInfos.stream().filter(clazz -> !((ApiTypeInfo)clazz.getRaw()).isConcrete()).collect(Collectors.toList());
    }
}

