/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.mods.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.file.FileProps;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.http.HttpServerRequest;

public class StaticFileHandler
implements Handler<HttpServerRequest> {
    private FileSystem fileSystem;
    private String webRootPrefix;
    private String indexPage;
    private boolean gzipFiles;
    private boolean caching;
    private ConcurrentMap<String, Long> filePropsModified;
    private SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

    public StaticFileHandler(Vertx vertx, String webRootPrefix) {
        this(vertx, webRootPrefix, "index.html", false, true);
    }

    public StaticFileHandler(Vertx vertx, String webRootPrefix, boolean gzipFiles, boolean caching) {
        this(vertx, webRootPrefix, "index.html", gzipFiles, caching);
    }

    public StaticFileHandler(Vertx vertx, String webRootPrefix, String indexPage, boolean gzipFiles, boolean caching) {
        this.filePropsModified = vertx.sharedData().getMap("webserver.fileProps.modified");
        this.fileSystem = vertx.fileSystem();
        this.webRootPrefix = webRootPrefix;
        this.indexPage = indexPage;
        this.gzipFiles = gzipFiles;
        this.caching = caching;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(HttpServerRequest req) {
        int error;
        boolean zipped;
        String fileName;
        block22: {
            String etag;
            long lastModifiedTime;
            block24: {
                int len$;
                String[] arr$;
                block25: {
                    int len$2;
                    String[] arr$2;
                    boolean matched;
                    block23: {
                        String acceptEncoding = req.headers().get("accept-encoding");
                        boolean acceptEncodingGzip = acceptEncoding == null ? false : acceptEncoding.contains("gzip");
                        try {
                            String checkEtags;
                            fileName = req.path().equals("/") ? this.indexPage : this.webRootPrefix + req.path();
                            boolean bl = zipped = this.gzipFiles && acceptEncodingGzip;
                            if (zipped && this.fileSystem.existsSync(fileName + ".gz")) {
                                fileName = fileName + ".gz";
                            }
                            error = 200;
                            if (!this.caching) break block22;
                            lastModifiedTime = this.checkCacheOrFileSystem(fileName);
                            etag = String.format("W/%d", lastModifiedTime);
                            if (req.headers().contains("if-match")) {
                                checkEtags = req.headers().get("if-match");
                                if (checkEtags.indexOf(44) > -1) {
                                    matched = false;
                                    arr$2 = checkEtags.split(", *");
                                    len$2 = arr$2.length;
                                    break block23;
                                }
                                if ("*".equals(checkEtags) && !this.fileSystem.existsSync(fileName)) {
                                    error = 412;
                                    break block24;
                                }
                                if (!etag.equals(checkEtags)) break block24;
                                error = 304;
                                break block24;
                            }
                            if (req.headers().contains("if-none-match")) {
                                checkEtags = req.headers().get("if-none-match");
                                if ("HEAD".equals(req.method()) || "GET".equals(req.method())) {
                                    if (checkEtags.indexOf(44) > -1) {
                                        arr$ = checkEtags.split(", *");
                                        len$ = arr$.length;
                                        break block25;
                                    }
                                    if ("*".equals(checkEtags)) {
                                        error = 304;
                                        break block24;
                                    }
                                    if (!etag.equals(checkEtags)) break block24;
                                    error = 304;
                                    break block24;
                                }
                                this.sendError(req, 412);
                                break block24;
                            }
                            if (!req.headers().contains("if-modified-since")) break block24;
                            try {
                                String ifModifiedSince = req.headers().get("if-modified-since");
                                long ifModifiedSinceTime = this.parseDateHeader(ifModifiedSince);
                                if (lastModifiedTime == ifModifiedSinceTime) {
                                    error = 304;
                                }
                                break block24;
                            }
                            catch (ParseException e) {
                                // empty catch block
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Failed to check file: " + e.getMessage());
                        }
                    }
                    for (int i$ = 0; i$ < len$2; ++i$) {
                        String checkEtag = arr$2[i$];
                        if (!etag.equals(checkEtag)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) break block24;
                    error = 412;
                    break block24;
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    String checkEtag = arr$[i$];
                    System.out.println(etag + " == " + checkEtag);
                    if (!etag.equals(checkEtag)) continue;
                    error = 304;
                    break;
                }
            }
            if (req.headers().contains("if-unmodified-since")) {
                try {
                    String ifUnmodifiedSince = req.headers().get("if-unmodified-since");
                    long ifUnmodifiedSinceTime = this.parseDateHeader(ifUnmodifiedSince);
                    if (lastModifiedTime > ifUnmodifiedSinceTime) {
                        error = 412;
                    }
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            this.setResponseHeader(req, "etag", etag);
            this.setResponseHeader(req, "last-modified", this.format.format(new Date(lastModifiedTime)));
        }
        if (zipped) {
            this.setResponseHeader(req, "content-encoding", "gzip");
        }
        if (error != 200) {
            this.sendError(req, error);
            return;
        }
        if ("HEAD".equals(req.method())) {
            req.response().end();
            return;
        }
        req.response().sendFile(fileName);
    }

    private long checkCacheOrFileSystem(String fileName) {
        if (this.filePropsModified.containsKey(fileName)) {
            return (Long)this.filePropsModified.get(fileName);
        }
        FileProps fileProps = this.fileSystem.propsSync(fileName);
        this.filePropsModified.put(fileName, fileProps.lastModifiedTime().getTime());
        return fileProps.lastModifiedTime().getTime();
    }

    private long parseDateHeader(String dateStr) throws ParseException {
        Date date = this.format.parse(dateStr);
        return date.getTime();
    }

    private void setResponseHeader(HttpServerRequest req, String header, String value) {
        req.response().putHeader(header, value);
    }

    private void sendError(HttpServerRequest req, int error) {
        this.sendError(req, error, "");
    }

    private void sendError(HttpServerRequest req, int error, String message) {
        req.response().setStatusMessage(message);
        req.response().setStatusCode(error);
        req.response().end();
    }
}

