/*
 * Decompiled with CFR 0.152.
 */
package io.trino.aws.proxy.spark4;

import io.trino.aws.proxy.spark4.PresignAwareSigner;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.DelegatingS3Client;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

public class PresignAwareS3Client
extends DelegatingS3Client {
    private static final Log log = LogFactory.getLog(PresignAwareS3Client.class);

    public PresignAwareS3Client(S3Client delegate) {
        super(delegate);
    }

    private Optional<URI> getPresignedUrl(String method, String bucket, String key, Optional<UploadPartRequest> uploadPartRequest) {
        Map headers;
        Optional<String> uploadId = uploadPartRequest.map(UploadPartRequest::uploadId);
        Optional<Integer> partNumber = uploadPartRequest.map(UploadPartRequest::partNumber);
        log.debug((Object)"request.get-presigned-url method=%s bucket=%s key=%s uploadId=%s partNumber=%s".formatted(method, bucket, key, uploadId, partNumber));
        try {
            HeadObjectResponse response = this.headObject(builder -> {
                builder.bucket(bucket).key(key);
                partNumber.ifPresent(arg_0 -> ((HeadObjectRequest.Builder)builder).partNumber(arg_0));
                uploadId.ifPresent(id -> builder.overrideConfiguration(c -> c.putRawQueryParameter("uploadId", id)));
            });
            headers = response.sdkHttpResponse().headers();
        }
        catch (AwsServiceException e) {
            boolean isGetOrDelete;
            boolean is404NotFound = e.statusCode() == 404;
            boolean bl = isGetOrDelete = method.equalsIgnoreCase("get") || method.equalsIgnoreCase("delete");
            if (is404NotFound && isGetOrDelete) {
                throw e;
            }
            headers = e.awsErrorDetails().sdkHttpResponse().headers();
        }
        catch (RuntimeException e) {
            log.error((Object)"request.get-presigned-url.exception method=%s bucket=%s key=%s uploadId=%s partNumber=%s".formatted(method, bucket, key, uploadId, partNumber), (Throwable)e);
            throw e;
        }
        List headerValue = (List)headers.get("X-Trino-Pre-Signed-Url-" + method);
        Optional<URI> presignedUri = Optional.ofNullable(headerValue).filter(list -> !list.isEmpty()).map(list -> URI.create(String.valueOf(list.get(0))));
        log.debug((Object)"response.get-presigned-url method=%s bucket=%s key=%s uploadId=%s partNumber=%s success=%s".formatted(method, bucket, key, uploadId, partNumber, presignedUri.isPresent()));
        return presignedUri;
    }

    private <T extends S3Request.Builder> T registerPresignedUrl(T builder, URI presignedUrl) {
        builder.overrideConfiguration(c -> c.signer((Signer)new PresignAwareSigner(presignedUrl)));
        return builder;
    }

    public <ReturnT> ReturnT getObject(GetObjectRequest getObjectRequest, ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws AwsServiceException, SdkClientException {
        return (ReturnT)this.getPresignedUrl("GET", getObjectRequest.bucket(), getObjectRequest.key(), Optional.empty()).map(presignedUrl -> super.getObject((GetObjectRequest)this.registerPresignedUrl((S3Request.Builder)getObjectRequest.toBuilder(), (URI)presignedUrl).build(), responseTransformer)).orElseGet(() -> super.getObject(getObjectRequest, responseTransformer));
    }

    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException {
        return this.getPresignedUrl("PUT", putObjectRequest.bucket(), putObjectRequest.key(), Optional.empty()).map(presignedUrl -> super.putObject((PutObjectRequest)this.registerPresignedUrl((S3Request.Builder)putObjectRequest.toBuilder(), (URI)presignedUrl).build(), requestBody)).orElseGet(() -> super.putObject(putObjectRequest, requestBody));
    }

    public UploadPartResponse uploadPart(UploadPartRequest uploadPartRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException {
        return this.getPresignedUrl("PUT", uploadPartRequest.bucket(), uploadPartRequest.key(), Optional.of(uploadPartRequest)).map(presignedUrl -> super.uploadPart((UploadPartRequest)this.registerPresignedUrl((S3Request.Builder)uploadPartRequest.toBuilder(), (URI)presignedUrl).build(), requestBody)).orElseGet(() -> super.uploadPart(uploadPartRequest, requestBody));
    }
}

