/*
 * Decompiled with CFR 0.152.
 */
package weaponregex.extension;

import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import weaponregex.extension.RegexTreeExtension$;
import weaponregex.extension.TokenMutatorExtension$;
import weaponregex.model.mutation.Mutant;
import weaponregex.model.mutation.TokenMutator;
import weaponregex.model.regextree.FlagToggle;
import weaponregex.model.regextree.Leaf;
import weaponregex.model.regextree.Node;
import weaponregex.model.regextree.RegexTree;
import weaponregex.mutator.BuiltinMutators$;

public final class RegexTreeExtension {
    public static RegexTreeMutator RegexTreeMutator(RegexTree regexTree) {
        return RegexTreeExtension$.MODULE$.RegexTreeMutator(regexTree);
    }

    public static RegexTreeStringBuilder RegexTreeStringBuilder(RegexTree regexTree) {
        return RegexTreeExtension$.MODULE$.RegexTreeStringBuilder(regexTree);
    }

    public static class RegexTreeMutator {
        private final RegexTree tree;

        public RegexTreeMutator(RegexTree tree) {
            this.tree = tree;
        }

        public Seq<Mutant> mutate(Seq<TokenMutator> mutators, Seq<Object> mutationLevels) {
            Seq seq;
            if (mutationLevels != null) {
                return this.mutate(TokenMutatorExtension$.MODULE$.TokenMutatorsFiltering(mutators).atLevels(mutationLevels), this.mutate$default$2());
            }
            Seq rootMutants = (Seq)mutators.flatMap((Function1 & Serializable)_$3 -> _$3.apply(this.tree));
            RegexTree regexTree = this.tree;
            if (regexTree instanceof Node) {
                Node node = (Node)regexTree;
                seq = (Seq)node.children().flatMap((Function1 & Serializable)child -> {
                    RegexTreeMutator regexTreeMutator = RegexTreeExtension$.MODULE$.RegexTreeMutator((RegexTree)child);
                    return (IterableOnce)regexTreeMutator.mutate(mutators, regexTreeMutator.mutate$default$2()).map((Function1 & Serializable)mutant -> mutant.copy(RegexTreeExtension$.MODULE$.RegexTreeStringBuilder(this.tree).buildWith((RegexTree)child, mutant.pattern()), mutant.copy$default$2(), mutant.copy$default$3(), mutant.copy$default$4(), mutant.copy$default$5()));
                });
            } else {
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
            Seq childrenMutants = seq;
            return (Seq)rootMutants.$plus$plus((IterableOnce)childrenMutants);
        }

        public Seq<TokenMutator> mutate$default$1() {
            return BuiltinMutators$.MODULE$.all();
        }

        public Seq<Object> mutate$default$2() {
            return null;
        }
    }

    public static class RegexTreeStringBuilder {
        private final RegexTree tree;
        private String build$lzy1;
        private boolean buildbitmap$1;

        public RegexTreeStringBuilder(RegexTree tree) {
            this.tree = tree;
        }

        public String build() {
            if (!this.buildbitmap$1) {
                String string;
                RegexTree regexTree = this.tree;
                if (regexTree instanceof Leaf) {
                    Leaf leaf = (Leaf)regexTree;
                    string = new StringBuilder(0).append(leaf.prefix()).append(leaf.value()).append(leaf.postfix()).toString();
                } else if (regexTree instanceof FlagToggle) {
                    FlagToggle ft = (FlagToggle)regexTree;
                    string = new StringBuilder(0).append(RegexTreeExtension$.MODULE$.RegexTreeStringBuilder(ft.onFlags()).build()).append(ft.hasDash() ? "-" : "").append(RegexTreeExtension$.MODULE$.RegexTreeStringBuilder(ft.offFlags()).build()).toString();
                } else {
                    string = this.buildWhile((Function1<RegexTree, Object>)(Function1 & Serializable)_$1 -> true);
                }
                this.build$lzy1 = string;
                this.buildbitmap$1 = true;
            }
            return this.build$lzy1;
        }

        public String buildWith(RegexTree child, String childString) {
            RegexTree regexTree = this.tree;
            if (regexTree instanceof Node) {
                Node node = (Node)regexTree;
                return ((IterableOnceOps)node.children().map((Function1 & Serializable)c -> {
                    if (c == child) {
                        return childString;
                    }
                    return RegexTreeExtension$.MODULE$.RegexTreeStringBuilder((RegexTree)c).build();
                })).mkString(node.prefix(), node.sep(), this.tree.postfix());
            }
            return this.build();
        }

        public String buildWhile(Function1<RegexTree, Object> pred) {
            RegexTree regexTree = this.tree;
            if (regexTree instanceof Node) {
                Node node = (Node)regexTree;
                return ((IterableOnceOps)((IterableOps)node.children().filter(pred)).map((Function1 & Serializable)_$2 -> RegexTreeExtension$.MODULE$.RegexTreeStringBuilder((RegexTree)_$2).build())).mkString(this.tree.prefix(), node.sep(), this.tree.postfix());
            }
            return this.build();
        }
    }
}

