/*
 * Decompiled with CFR 0.152.
 */
package io.squashql.client.http;

import feign.Client;
import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import io.squashql.jackson.JacksonUtil;
import io.squashql.query.Measure;
import io.squashql.query.dto.MetadataResultDto;
import io.squashql.query.dto.PivotTableQueryDto;
import io.squashql.query.dto.PivotTableQueryResultDto;
import io.squashql.query.dto.QueryDto;
import io.squashql.query.dto.QueryMergeDto;
import io.squashql.query.dto.QueryResultDto;
import java.util.List;

public class HttpClientQuerier {
    private static final okhttp3.OkHttpClient client = new okhttp3.OkHttpClient();
    private static final Feign.Builder builder = Feign.builder().client((Client)new OkHttpClient(client)).encoder((Encoder)new JacksonEncoder(JacksonUtil.OBJECT_MAPPER)).decoder((Decoder)new JacksonDecoder(JacksonUtil.OBJECT_MAPPER));
    public String url;

    public HttpClientQuerier(String url) {
        this.url = url;
    }

    public QueryResultDto run(QueryDto query) {
        QueryApi target = (QueryApi)builder.target(QueryApi.class, this.url);
        return target.run(query);
    }

    public PivotTableQueryResultDto run(PivotTableQueryDto query) {
        QueryApi target = (QueryApi)builder.target(QueryApi.class, this.url);
        return target.run(query);
    }

    public QueryResultDto queryMerge(QueryMergeDto query) {
        QueryApi target = (QueryApi)builder.target(QueryApi.class, this.url);
        return target.queryMerge(query);
    }

    public MetadataResultDto metadata() {
        QueryApi target = (QueryApi)builder.target(QueryApi.class, this.url);
        return target.metadata();
    }

    public List<Measure> expression(List<Measure> measures) {
        QueryApi target = (QueryApi)builder.target(QueryApi.class, this.url);
        return target.expression(measures);
    }

    static interface QueryApi {
        @RequestLine(value="POST /query")
        @Headers(value={"Content-Type: application/json"})
        public QueryResultDto run(QueryDto var1);

        @RequestLine(value="POST /query-pivot")
        @Headers(value={"Content-Type: application/json"})
        public PivotTableQueryResultDto run(PivotTableQueryDto var1);

        @RequestLine(value="POST /query-merge")
        @Headers(value={"Content-Type: application/json"})
        public QueryResultDto queryMerge(QueryMergeDto var1);

        @RequestLine(value="GET /metadata")
        public MetadataResultDto metadata();

        @RequestLine(value="POST /expression")
        @Headers(value={"Content-Type: application/json"})
        public List<Measure> expression(List<Measure> var1);
    }
}

