/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import io.servicetalk.utils.internal.PlatformDependent0;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Queue;
import org.jctools.queues.MpscChunkedArrayQueue;
import org.jctools.queues.MpscLinkedQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jctools.queues.SpscChunkedArrayQueue;
import org.jctools.queues.SpscUnboundedArrayQueue;
import org.jctools.queues.atomic.MpscGrowableAtomicArrayQueue;
import org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import org.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import org.jctools.queues.atomic.SpscGrowableAtomicArrayQueue;
import org.jctools.queues.atomic.SpscUnboundedAtomicArrayQueue;
import org.jctools.queues.ea.unpadded.MpscChunkedUnpaddedArrayQueue;
import org.jctools.queues.ea.unpadded.MpscLinkedUnpaddedQueue;
import org.jctools.queues.ea.unpadded.MpscUnboundedUnpaddedArrayQueue;
import org.jctools.queues.ea.unpadded.SpscChunkedUnpaddedArrayQueue;
import org.jctools.queues.ea.unpadded.SpscUnboundedUnpaddedArrayQueue;
import org.jctools.util.UnsafeAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformDependent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformDependent.class);
    private static final int QUEUE_CHUNK_SIZE = 1024;
    private static final int MIN_MAX_MPSC_CAPACITY = 4;
    private static final int MIN_MAX_SPSC_CAPACITY = 16;
    private static final int MAX_ALLOWED_QUEUE_CAPACITY = 0x40000000;
    private static final int MIN_ALLOWED_SPSC_CHUNK_SIZE = 8;
    private static final int MIN_ALLOWED_MPSC_CHUNK_SIZE = 2;
    private static final Object DUMMY = new Object();

    private PlatformDependent() {
    }

    public static boolean hasUnsafe() {
        return PlatformDependent0.hasUnsafe();
    }

    public static boolean useDirectBufferWithoutZeroing() {
        return PlatformDependent0.useDirectBufferWithoutZeroing();
    }

    public static void reserveMemory(long size, int capacity) {
        PlatformDependent0.reserveMemory(size, capacity);
    }

    public static void unreserveMemory(long size, int capacity) {
        PlatformDependent0.unreserveMemory(size, capacity);
    }

    public static long allocateMemory(long size) {
        return PlatformDependent0.allocateMemory(size);
    }

    public static void freeMemory(long address) {
        PlatformDependent0.freeMemory(address);
    }

    public static ByteBuffer newDirectBuffer(long address, long size, int capacity) {
        return PlatformDependent0.newDirectBuffer(address, size, capacity);
    }

    public static <T> T throwException(Throwable t) {
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent0.throwException(t);
        } else {
            PlatformDependent.throwException0(t);
        }
        return PlatformDependent.uncheckedCast();
    }

    private static <E extends Throwable> void throwException0(Throwable t) throws E {
        throw t;
    }

    private static <T> T uncheckedCast() {
        return (T)DUMMY;
    }

    public static <T> Queue<T> newUnboundedMpscQueue() {
        return PlatformDependent.newUnboundedMpscQueue(1024);
    }

    public static <T> Queue<T> newUnboundedMpscQueue(int initialCapacity) {
        return Queues.newUnboundedMpscQueue(initialCapacity);
    }

    public static <T> Queue<T> newMpscQueue(int maxCapacity) {
        return PlatformDependent.newMpscQueue(1024, maxCapacity);
    }

    public static <T> Queue<T> newMpscQueue(int initialCapacity, int maxCapacity) {
        return Queues.newMpscQueue(initialCapacity, maxCapacity);
    }

    public static <T> Queue<T> newUnboundedLinkedMpscQueue() {
        return Queues.newUnboundedLinkedMpscQueue();
    }

    public static <T> Queue<T> newSpscQueue(int maxCapacity) {
        return PlatformDependent.newSpscQueue(1024, maxCapacity);
    }

    public static <T> Queue<T> newSpscQueue(int initialCapacity, int maxCapacity) {
        return Queues.newSpscQueue(initialCapacity, maxCapacity);
    }

    public static <T> Queue<T> newUnboundedSpscQueue(int initialCapacity) {
        return Queues.newUnboundedSpscQueue(initialCapacity);
    }

    private static final class Queues {
        private static final boolean USE_UNSAFE_QUEUES;
        private static final boolean USE_UNPADDED_QUEUES;

        private Queues() {
        }

        static <T> Queue<T> newMpscQueue(int initialCapacity, int maxCapacity) {
            int initialCap = Math.max(2, initialCapacity);
            int capacity = Math.max(Math.min(maxCapacity, 0x40000000), 4);
            return USE_UNSAFE_QUEUES ? (USE_UNPADDED_QUEUES ? new MpscChunkedUnpaddedArrayQueue(initialCap, capacity) : new MpscChunkedArrayQueue(initialCap, capacity)) : new MpscGrowableAtomicArrayQueue(initialCap, capacity);
        }

        static <T> Queue<T> newUnboundedMpscQueue(int initialCapacity) {
            return USE_UNSAFE_QUEUES ? (USE_UNPADDED_QUEUES ? new MpscUnboundedUnpaddedArrayQueue(Math.max(2, initialCapacity)) : new MpscUnboundedArrayQueue(Math.max(2, initialCapacity))) : new MpscUnboundedAtomicArrayQueue(Math.max(2, initialCapacity));
        }

        static <T> Queue<T> newUnboundedLinkedMpscQueue() {
            return USE_UNSAFE_QUEUES ? (USE_UNPADDED_QUEUES ? new MpscLinkedUnpaddedQueue() : new MpscLinkedQueue()) : new MpscLinkedAtomicQueue();
        }

        static <T> Queue<T> newSpscQueue(int initialCapacity, int maxCapacity) {
            int initialCap = Math.max(8, initialCapacity);
            int capacity = Math.max(Math.min(maxCapacity, 0x40000000), 16);
            return USE_UNSAFE_QUEUES ? (USE_UNPADDED_QUEUES ? new SpscChunkedUnpaddedArrayQueue(initialCap, capacity) : new SpscChunkedArrayQueue(initialCap, capacity)) : new SpscGrowableAtomicArrayQueue(initialCap, capacity);
        }

        static <T> Queue<T> newUnboundedSpscQueue(int initialCapacity) {
            return USE_UNSAFE_QUEUES ? (USE_UNPADDED_QUEUES ? new SpscUnboundedUnpaddedArrayQueue(initialCapacity) : new SpscUnboundedArrayQueue(initialCapacity)) : new SpscUnboundedAtomicArrayQueue(initialCapacity);
        }

        static {
            String useUnpaddedQueuesName = "io.servicetalk.internal.queues.useUnpadded";
            boolean useUnpaddedQueues = Boolean.getBoolean("io.servicetalk.internal.queues.useUnpadded");
            if (useUnpaddedQueues) {
                MpscLinkedUnpaddedQueue queue = null;
                try {
                    queue = new MpscLinkedUnpaddedQueue();
                }
                catch (Throwable ignored) {
                    useUnpaddedQueues = false;
                }
                LOGGER.debug("jctools unpadded: {}available.", (Object)(queue == null ? "un" : ""));
            }
            LOGGER.debug("{}: {}", (Object)"io.servicetalk.internal.queues.useUnpadded", (Object)useUnpaddedQueues);
            USE_UNPADDED_QUEUES = useUnpaddedQueues;
            Object unsafe = null;
            if (PlatformDependent.hasUnsafe()) {
                unsafe = AccessController.doPrivileged(() -> UnsafeAccess.UNSAFE);
            }
            if (unsafe == null) {
                LOGGER.debug("jctools Unbounded/ChunkedArrayQueue: unavailable.");
                USE_UNSAFE_QUEUES = false;
            } else {
                LOGGER.debug("jctools Unbounded/ChunkedArrayQueue: available.");
                USE_UNSAFE_QUEUES = true;
            }
        }
    }
}

