/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.log4j2.mdc.utils;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class ServiceTalkThreadContextMap
implements ReadOnlyThreadContextMap,
CleanableThreadContextMap {
    private static final AsyncContextMap.Key<Map<String, String>> key = AsyncContextMap.Key.newKey((String)"log4j2Mdc");

    public final void put(String key, String value) {
        ServiceTalkThreadContextMap.getStorage().put(key, value);
    }

    @Nullable
    public String get(String key) {
        return ServiceTalkThreadContextMap.getStorage().get(key);
    }

    public final void remove(String key) {
        ServiceTalkThreadContextMap.getStorage().remove(key);
    }

    public final void clear() {
        ServiceTalkThreadContextMap.getStorage().clear();
    }

    public boolean containsKey(String key) {
        return ServiceTalkThreadContextMap.getStorage().containsKey(key);
    }

    public Map<String, String> getCopy() {
        return this.getCopy(ServiceTalkThreadContextMap.getStorage());
    }

    protected Map<String, String> getCopy(Map<String, String> storage) {
        return new HashMap<String, String>(storage);
    }

    @Nullable
    public final Map<String, String> getImmutableMapOrNull() {
        return this.getImmutableMapOrNull(ServiceTalkThreadContextMap.getStorage());
    }

    @Nullable
    protected Map<String, String> getImmutableMapOrNull(Map<String, String> storage) {
        if (storage.isEmpty()) {
            return null;
        }
        Map<String, String> copy = this.getCopy(storage);
        return copy.isEmpty() ? null : Collections.unmodifiableMap(copy);
    }

    public boolean isEmpty() {
        return ServiceTalkThreadContextMap.getStorage().isEmpty();
    }

    public final void removeAll(Iterable<String> keys) {
        Map<String, String> storage = ServiceTalkThreadContextMap.getStorage();
        keys.forEach(storage::remove);
    }

    public final void putAll(Map<String, String> map) {
        ServiceTalkThreadContextMap.getStorage().putAll(map);
    }

    public final StringMap getReadOnlyContextData() {
        return this.getReadOnlyContextData(ServiceTalkThreadContextMap.getStorage());
    }

    protected StringMap getReadOnlyContextData(final Map<String, String> storage) {
        return new StringMap(){
            private static final long serialVersionUID = -1707426073379541244L;

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public void freeze() {
            }

            public boolean isFrozen() {
                return true;
            }

            public void putAll(ReadOnlyStringMap source) {
                throw new UnsupportedOperationException();
            }

            public void putValue(String key, Object value) {
                throw new UnsupportedOperationException();
            }

            public void remove(String key) {
                throw new UnsupportedOperationException();
            }

            public Map<String, String> toMap() {
                return ServiceTalkThreadContextMap.this.getCopy(storage);
            }

            public boolean containsKey(String key) {
                return storage.containsKey(key);
            }

            public <V> void forEach(BiConsumer<String, ? super V> action) {
                storage.forEach((? super K key, ? super V value) -> action.accept(key, value));
            }

            public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
                storage.forEach((? super K key, ? super V value) -> action.accept(key, value, state));
            }

            public <V> V getValue(String key) {
                return storage.get(key);
            }

            public boolean isEmpty() {
                return storage.isEmpty();
            }

            public int size() {
                return storage.size();
            }
        };
    }

    static Map<String, String> getStorage() {
        AsyncContextMap context = AsyncContext.current();
        ConcurrentHashMap ret = (ConcurrentHashMap)context.get(key);
        if (ret == null) {
            ret = new ConcurrentHashMap(4);
            AsyncContext.put(key, ret);
        }
        return ret;
    }
}

