/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.internal.ConnectableBufferOutputStream;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.router.jersey.BufferedResponseOutputStream;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultContainerResponseWriter
implements ContainerResponseWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContainerResponseWriter.class);
    private static final Map<Response.Status, HttpResponseStatus> RESPONSE_STATUSES = Collections.unmodifiableMap(Arrays.stream(Response.Status.values()).collect(Collectors.toMap(Function.identity(), s -> HttpResponseStatus.of((int)s.getStatusCode(), (String)s.getReasonPhrase()))));
    private static final int UNKNOWN_RESPONSE_LENGTH = -1;
    private static final int STATE_REQUEST_HANDLING = 0;
    private static final int STATE_RESPONSE_WRITING = 1;
    private static final int STATE_REQUEST_CANCELLED = 2;
    private static final AtomicIntegerFieldUpdater<DefaultContainerResponseWriter> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultContainerResponseWriter.class, "state");
    private final ContainerRequest request;
    private final HttpProtocolVersion protocolVersion;
    private final HttpServiceContext serviceCtx;
    private final StreamingHttpResponseFactory responseFactory;
    private final SingleSource.Subscriber<? super StreamingHttpResponse> responseSubscriber;
    @Nullable
    private volatile Cancellable suspendedTimerCancellable;
    @Nullable
    private volatile Runnable suspendedTimeoutRunnable;
    private volatile int state;

    DefaultContainerResponseWriter(ContainerRequest request, HttpProtocolVersion protocolVersion, HttpServiceContext serviceCtx, StreamingHttpResponseFactory responseFactory, SingleSource.Subscriber<? super StreamingHttpResponse> responseSubscriber) {
        this.request = Objects.requireNonNull(request);
        this.protocolVersion = Objects.requireNonNull(protocolVersion);
        this.serviceCtx = Objects.requireNonNull(serviceCtx);
        this.responseFactory = Objects.requireNonNull(responseFactory);
        this.responseSubscriber = Objects.requireNonNull(responseSubscriber);
    }

    @Nullable
    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
        if (!stateUpdater.compareAndSet(this, 0, 1)) {
            return null;
        }
        Publisher content = RequestProperties.getResponseBufferPublisher((ContainerRequestContext)this.request);
        if (content != null) {
            this.sendResponse(-1L, (Publisher<Buffer>)content, responseContext);
            return null;
        }
        if (contentLength == 0L || this.isHeadRequest()) {
            this.sendResponse(contentLength, null, responseContext);
            return null;
        }
        if (contentLength > 0L) {
            return new BufferedResponseOutputStream(this.serviceCtx.executionContext().bufferAllocator(), buf -> this.sendResponse(contentLength, (Publisher<Buffer>)Publisher.from((Object)buf), responseContext));
        }
        ConnectableBufferOutputStream os = new ConnectableBufferOutputStream(this.serviceCtx.executionContext().bufferAllocator());
        this.sendResponse(contentLength, (Publisher<Buffer>)os.connect(), responseContext);
        return new CopyingOutputStream((OutputStream)os);
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, @Nullable ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        Runnable r;
        this.suspendedTimeoutRunnable = r = timeoutHandler != null ? () -> timeoutHandler.onTimeout((ContainerResponseWriter)this) : () -> {};
        this.scheduleSuspendedTimer(timeOut, timeUnit, r);
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        Runnable r = this.suspendedTimeoutRunnable;
        if (r == null) {
            throw new IllegalStateException("Request is not suspended");
        }
        this.cancelSuspendedTimer();
        this.scheduleSuspendedTimer(timeOut, timeUnit, r);
    }

    private void scheduleSuspendedTimer(long timeOut, TimeUnit timeUnit, Runnable r) {
        if (timeOut > 0L) {
            this.suspendedTimerCancellable = this.serviceCtx.executionContext().executor().schedule(r, timeOut, timeUnit);
        }
    }

    public void commit() {
        this.suspendedTimeoutRunnable = null;
        this.cancelSuspendedTimer();
    }

    public void failure(Throwable error) {
        this.suspendedTimeoutRunnable = null;
        this.cancelSuspendedTimer();
        this.responseSubscriber.onError(error);
    }

    void dispose() {
        if (stateUpdater.compareAndSet(this, 0, 2)) {
            try {
                RequestProperties.getRequestCancellable((ContainerRequestContext)this.request).cancel();
                this.request.close();
                this.cancelSuspendedTimer();
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to dispose during request handling phase", t);
            }
        }
    }

    private void cancelResponse() {
        if (stateUpdater.compareAndSet(this, 1, 2)) {
            try {
                this.request.close();
                this.cancelSuspendedTimer();
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to cancel during response writing phase", t);
            }
        }
    }

    private void cancelSuspendedTimer() {
        Cancellable c = this.suspendedTimerCancellable;
        if (c != null) {
            c.cancel();
        }
    }

    public boolean enableResponseBuffering() {
        return true;
    }

    private void sendResponse(long contentLength, @Nullable Publisher<Buffer> content, ContainerResponse containerResponse) {
        StreamingHttpResponse response;
        HttpResponseStatus status = DefaultContainerResponseWriter.getStatus(containerResponse);
        if (content != null && !this.isHeadRequest()) {
            HttpExecutionStrategy executionStrategy = RequestProperties.getResponseExecutionStrategy((ContainerRequestContext)this.request);
            Publisher payloadBody = (executionStrategy != null ? executionStrategy.offloadSend(this.serviceCtx.executionContext().executor(), content) : content).beforeCancel(this::cancelResponse);
            response = this.responseFactory.newResponse(status).version(this.protocolVersion).payloadBody(payloadBody);
        } else {
            response = this.responseFactory.newResponse(status).version(this.protocolVersion);
        }
        HttpHeaders headers = response.headers();
        boolean isH2 = response.version().major() == 2;
        containerResponse.getHeaders().forEach((k, vs) -> vs.forEach(v -> headers.add((CharSequence)(isH2 ? k.toLowerCase() : k), v == null ? CharSequences.emptyAsciiString() : DefaultContainerResponseWriter.asCharSequence(v))));
        if (!headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            if (contentLength == -1L) {
                if (!this.isHeadRequest() && !HttpProtocolVersion.HTTP_1_0.equals((Object)this.protocolVersion)) {
                    headers.set(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
                }
            } else {
                headers.set(HttpHeaderNames.CONTENT_LENGTH, contentLength == 0L ? HttpHeaderValues.ZERO : Long.toString(contentLength));
                headers.removeIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
            }
        }
        this.responseSubscriber.onSuccess((Object)response);
    }

    private static HttpResponseStatus getStatus(ContainerResponse containerResponse) {
        Response.StatusType statusInfo = containerResponse.getStatusInfo();
        return statusInfo instanceof Response.Status ? RESPONSE_STATUSES.get(statusInfo) : HttpResponseStatus.of((int)statusInfo.getStatusCode(), (String)statusInfo.getReasonPhrase());
    }

    private static CharSequence asCharSequence(Object o) {
        return o instanceof CharSequence ? (CharSequence)o : o.toString();
    }

    private boolean isHeadRequest() {
        return "HEAD".equals(this.request.getMethod());
    }

    private static final class CopyingOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        CopyingOutputStream(OutputStream delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            byte[] result = new byte[b.length];
            System.arraycopy(b, 0, result, 0, result.length);
            this.delegate.write(result);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] result = new byte[len];
            System.arraycopy(b, off, result, 0, result.length);
            this.delegate.write(result);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

