/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import java.util.EnumSet;

enum DefaultHttpExecutionStrategy implements HttpExecutionStrategy
{
    OFFLOAD_NONE_STRATEGY(EnumSet.noneOf(HttpExecutionStrategies.HttpOffload.class)),
    OFFLOAD_RECEIVE_META_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META)),
    OFFLOAD_RECEIVE_DATA_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA)),
    OFFLOAD_RECEIVE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA)),
    OFFLOAD_SEND_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_RECEIVE_META_AND_SEND_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_RECEIVE_DATA_AND_SEND_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_ALL_REQRESP_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_META_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_DATA_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_SEND_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_META_AND_SEND_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_DATA_AND_SEND_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOADD_ALL_REQRESP_EVENT_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE)),
    OFFLOAD_RECEIVE_META_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META)),
    OFFLOAD_RECEIVE_DATA_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA)),
    OFFLOAD_RECEIVE_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA)),
    OFFLOAD_SEND_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_RECEIVE_META_AND_SEND_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_RECEIVE_DATA_AND_SEND_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND)),
    OFFLOAD_ALL_REQRESP_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE)),
    OFFLOAD_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_META_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_DATA_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_SEND_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_META_AND_SEND_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_RECEIVE_DATA_AND_SEND_EVENT_CLOSE_STRATEGY(EnumSet.of(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE, HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA, HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND, HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT)),
    OFFLOAD_ALL_STRATEGY(EnumSet.allOf(HttpExecutionStrategies.HttpOffload.class));

    private static final byte REQUEST_RESPONSE_MASK;
    private static final DefaultHttpExecutionStrategy[] VALUES;
    private final byte offloads;

    private DefaultHttpExecutionStrategy(EnumSet<HttpExecutionStrategies.HttpOffload> offloads) {
        this.offloads = HttpExecutionStrategies.HttpOffload.toMask(offloads);
    }

    static DefaultHttpExecutionStrategy fromMask(byte mask) {
        if (mask < 0 || mask >= VALUES.length) {
            throw new IllegalArgumentException("Unsupported offload flags mask");
        }
        return VALUES[mask];
    }

    @Override
    public boolean hasOffloads() {
        return this.offloads != 0;
    }

    @Override
    public boolean isRequestResponseOffloaded() {
        return (this.offloads & REQUEST_RESPONSE_MASK) != 0;
    }

    @Override
    public boolean isMetadataReceiveOffloaded() {
        return this.offloaded(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META);
    }

    @Override
    public boolean isDataReceiveOffloaded() {
        return this.offloaded(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA);
    }

    @Override
    public boolean isSendOffloaded() {
        return this.offloaded(HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND);
    }

    @Override
    public boolean isEventOffloaded() {
        return this.offloaded(HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT);
    }

    public boolean isCloseOffloaded() {
        return this.offloaded(HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE);
    }

    @Override
    public HttpExecutionStrategy merge(HttpExecutionStrategy other) {
        if (this == other) {
            return this;
        }
        if (!(other instanceof DefaultHttpExecutionStrategy)) {
            return other.merge(this);
        }
        byte otherOffloads = DefaultHttpExecutionStrategy.generateOffloadsFlag(other);
        return this.offloads == (this.offloads | otherOffloads) ? this : DefaultHttpExecutionStrategy.fromMask((byte)(this.offloads | otherOffloads));
    }

    private static byte generateOffloadsFlag(HttpExecutionStrategy strategy) {
        return strategy instanceof DefaultHttpExecutionStrategy ? ((DefaultHttpExecutionStrategy)strategy).offloads : (byte)((strategy.isDataReceiveOffloaded() ? HttpExecutionStrategies.HttpOffload.OFFLOAD_CLOSE.mask() : (byte)0) | (strategy.isDataReceiveOffloaded() ? HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA.mask() : (byte)0) | (strategy.isMetadataReceiveOffloaded() ? HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META.mask() : (byte)0) | (strategy.isSendOffloaded() ? HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND.mask() : (byte)0) | (strategy.isEventOffloaded() ? HttpExecutionStrategies.HttpOffload.OFFLOAD_EVENT.mask() : (byte)0));
    }

    boolean offloaded(HttpExecutionStrategies.HttpOffload flag) {
        byte mask = flag.mask();
        return (this.offloads & mask) == mask;
    }

    static {
        REQUEST_RESPONSE_MASK = (byte)(HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_META.mask() | HttpExecutionStrategies.HttpOffload.OFFLOAD_RECEIVE_DATA.mask() | HttpExecutionStrategies.HttpOffload.OFFLOAD_SEND.mask());
        VALUES = DefaultHttpExecutionStrategy.values();
    }
}

