/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.ProxyConfig;
import java.util.Objects;
import java.util.function.Consumer;

public final class ProxyConfigBuilder<A> {
    private static final Consumer<HttpHeaders> NOOP_HEADERS_CONSUMER = new Consumer<HttpHeaders>(){

        @Override
        public void accept(HttpHeaders headers) {
        }

        public String toString() {
            return "NOOP_HEADERS_CONSUMER";
        }
    };
    private final A address;
    private Consumer<HttpHeaders> connectRequestHeadersInitializer = NOOP_HEADERS_CONSUMER;

    public ProxyConfigBuilder(A address) {
        this.address = Objects.requireNonNull(address);
    }

    public ProxyConfigBuilder<A> connectRequestHeadersInitializer(Consumer<HttpHeaders> connectRequestHeadersInitializer) {
        this.connectRequestHeadersInitializer = Objects.requireNonNull(connectRequestHeadersInitializer);
        return this;
    }

    public ProxyConfig<A> build() {
        return new DefaultProxyConfig(this.address, this.connectRequestHeadersInitializer);
    }

    private static final class DefaultProxyConfig<A>
    implements ProxyConfig<A> {
        private final A address;
        private final Consumer<HttpHeaders> connectRequestHeadersInitializer;

        private DefaultProxyConfig(A address, Consumer<HttpHeaders> connectRequestHeadersInitializer) {
            this.address = address;
            this.connectRequestHeadersInitializer = connectRequestHeadersInitializer;
        }

        @Override
        public A address() {
            return this.address;
        }

        @Override
        public Consumer<HttpHeaders> connectRequestHeadersInitializer() {
            return this.connectRequestHeadersInitializer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultProxyConfig)) {
                return false;
            }
            DefaultProxyConfig that = (DefaultProxyConfig)o;
            if (!this.address.equals(that.address)) {
                return false;
            }
            return this.connectRequestHeadersInitializer.equals(that.connectRequestHeadersInitializer);
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = 31 * result + this.connectRequestHeadersInitializer.hashCode();
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{address=" + this.address + ", connectRequestHeadersInitializer=" + this.connectRequestHeadersInitializer + '}';
        }
    }
}

