/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpDeserializer2;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSerializer2;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.TrailersHolder;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public interface HttpRequest
extends HttpRequestMetaData,
TrailersHolder {
    public Buffer payloadBody();

    @Deprecated
    default public <T> T payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public <T> T payloadBody(HttpDeserializer2<T> var1);

    public HttpRequest payloadBody(Buffer var1);

    @Deprecated
    default public <T> HttpRequest payloadBody(T pojo, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("HttpRequest#payloadBody(Object, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to HttpRequest#payloadBody(Object, HttpSerializer2) or implement this method if it's required temporarily.");
    }

    public <T> HttpRequest payloadBody(T var1, HttpSerializer2<T> var2);

    public StreamingHttpRequest toStreamingRequest();

    public BlockingStreamingHttpRequest toBlockingStreamingRequest();

    @Override
    public HttpRequest rawPath(String var1);

    @Override
    public HttpRequest path(String var1);

    @Override
    public HttpRequest appendPathSegments(String ... var1);

    @Override
    public HttpRequest rawQuery(@Nullable String var1);

    @Override
    public HttpRequest query(@Nullable String var1);

    @Override
    public HttpRequest addQueryParameter(String var1, @Nullable String var2);

    @Override
    public HttpRequest addQueryParameters(String var1, Iterable<String> var2);

    @Override
    public HttpRequest addQueryParameters(String var1, String ... var2);

    @Override
    public HttpRequest setQueryParameter(String var1, @Nullable String var2);

    @Override
    public HttpRequest setQueryParameters(String var1, Iterable<String> var2);

    @Override
    public HttpRequest setQueryParameters(String var1, String ... var2);

    @Override
    default public HttpRequest fragment(@Nullable String fragment) {
        throw new UnsupportedOperationException("HttpRequest#fragment(String) is not supported by " + this.getClass());
    }

    @Override
    public HttpRequest version(HttpProtocolVersion var1);

    @Override
    @Deprecated
    default public HttpRequest encoding(ContentCodec encoding) {
        throw new UnsupportedOperationException("HttpRequest#encoding(ContentCodec) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to provided alternatives or implement this method if it's required temporarily.");
    }

    @Override
    public HttpRequest contentEncoding(@Nullable BufferEncoder var1);

    @Override
    public HttpRequest method(HttpRequestMethod var1);

    @Override
    public HttpRequest requestTarget(String var1);

    @Override
    public HttpRequest requestTarget(String var1, Charset var2);

    @Override
    default public HttpRequest addHeader(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public HttpRequest addHeaders(HttpHeaders headers) {
        HttpRequestMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public HttpRequest setHeader(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public HttpRequest setHeaders(HttpHeaders headers) {
        HttpRequestMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public HttpRequest addCookie(HttpCookiePair cookie) {
        HttpRequestMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public HttpRequest addCookie(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public HttpRequest addSetCookie(HttpSetCookie cookie) {
        HttpRequestMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public HttpRequest addSetCookie(CharSequence name, CharSequence value) {
        HttpRequestMetaData.super.addSetCookie(name, value);
        return this;
    }

    @Override
    default public HttpRequest addTrailer(CharSequence name, CharSequence value) {
        TrailersHolder.super.addTrailer(name, value);
        return this;
    }

    @Override
    default public HttpRequest addTrailers(HttpHeaders trailers) {
        TrailersHolder.super.addTrailers(trailers);
        return this;
    }

    @Override
    default public HttpRequest setTrailer(CharSequence name, CharSequence value) {
        TrailersHolder.super.setTrailer(name, value);
        return this;
    }

    @Override
    default public HttpRequest setTrailers(HttpHeaders trailers) {
        TrailersHolder.super.setTrailers(trailers);
        return this;
    }

    @Override
    public HttpRequest context(ContextMap var1);
}

