/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.Http2Settings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class Http2SettingsBuilder {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final int MAX_FRAME_SIZE_LOWER_BOUND = 16384;
    private static final int MAX_FRAME_SIZE_UPPER_BOUND = 0xFFFFFF;
    private static final char HEADER_TABLE_SIZE = '\u0001';
    private static final char ENABLE_PUSH = '\u0002';
    private static final char MAX_CONCURRENT_STREAMS = '\u0003';
    private static final char INITIAL_WINDOW_SIZE = '\u0004';
    private static final char MAX_FRAME_SIZE = '\u0005';
    private static final char MAX_HEADER_LIST_SIZE = '\u0006';
    private static final int DEFAULT_INITIAL_WINDOW_SIZE = 0x100000;
    private static final long DEFAULT_MAX_HEADER_LIST_SIZE = 8192L;
    private final Map<Character, Long> settings = new HashMap<Character, Long>(6);

    public Http2SettingsBuilder() {
        this.initialWindowSize(0x100000);
        this.maxHeaderListSize(8192L);
    }

    public Http2SettingsBuilder headerTableSize(long value) {
        Http2SettingsBuilder.validate32Unsigned(value);
        this.settings.put(Character.valueOf('\u0001'), value);
        return this;
    }

    public Http2SettingsBuilder maxConcurrentStreams(long value) {
        Http2SettingsBuilder.validate32Unsigned(value);
        this.settings.put(Character.valueOf('\u0003'), value);
        return this;
    }

    @Deprecated
    public Http2SettingsBuilder initialWindowSize(long value) {
        Http2SettingsBuilder.validate31Unsigned(value);
        return this.initialWindowSize((int)value);
    }

    public Http2SettingsBuilder initialWindowSize(int value) {
        Http2SettingsBuilder.validate31Unsigned(value);
        this.settings.put(Character.valueOf('\u0004'), Long.valueOf(value));
        return this;
    }

    public Http2SettingsBuilder maxFrameSize(int value) {
        if (value < 16384 || value > 0xFFFFFF) {
            throw new IllegalArgumentException("value: " + value + "(expected [" + 16384 + ", " + 0xFFFFFF + "]");
        }
        this.settings.put(Character.valueOf('\u0005'), Long.valueOf(value));
        return this;
    }

    public Http2SettingsBuilder maxHeaderListSize(long value) {
        Http2SettingsBuilder.validate32Unsigned(value);
        this.settings.put(Character.valueOf('\u0006'), value);
        return this;
    }

    public Http2Settings build() {
        return new DefaultHttp2Settings(new HashMap<Character, Long>(this.settings));
    }

    private static void validate32Unsigned(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("value: " + value + "(expected [0, " + 0xFFFFFFFFL + "]");
        }
    }

    private static void validate31Unsigned(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value: " + value + "(expected [0, " + Integer.MAX_VALUE + "]");
        }
    }

    private static void validate31Unsigned(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value: " + value + "(expected [0, " + Integer.MAX_VALUE + "]");
        }
    }

    private static final class DefaultHttp2Settings
    implements Http2Settings {
        private static final String SEPARATOR = ", ";
        private final Map<Character, Long> settings;

        private DefaultHttp2Settings(Map<Character, Long> settings) {
            this.settings = settings;
        }

        @Override
        @Nullable
        public Long headerTableSize() {
            return this.settings.get(Character.valueOf('\u0001'));
        }

        @Override
        @Nullable
        public Long maxConcurrentStreams() {
            return this.settings.get(Character.valueOf('\u0003'));
        }

        @Override
        @Nullable
        public Integer initialWindowSize() {
            return DefaultHttp2Settings.toInteger(this.settings.get(Character.valueOf('\u0004')));
        }

        @Override
        @Nullable
        public Integer maxFrameSize() {
            return DefaultHttp2Settings.toInteger(this.settings.get(Character.valueOf('\u0005')));
        }

        @Override
        @Nullable
        public Long maxHeaderListSize() {
            return this.settings.get(Character.valueOf('\u0006'));
        }

        @Override
        @Nullable
        public Long settingValue(char identifier) {
            return this.settings.get(Character.valueOf(identifier));
        }

        @Override
        public void forEach(BiConsumer<? super Character, ? super Long> action) {
            this.settings.forEach(action);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.settings.size() * 30);
            sb.append('{');
            this.settings.forEach((? super K identity, ? super V value) -> sb.append(DefaultHttp2Settings.identityToString(identity)).append('=').append(value).append(SEPARATOR));
            if (sb.length() > SEPARATOR.length()) {
                sb.setLength(sb.length() - SEPARATOR.length());
            }
            return sb.append('}').toString();
        }

        public int hashCode() {
            return this.settings.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DefaultHttp2Settings && this.settings.equals(((DefaultHttp2Settings)o).settings);
        }

        private static String identityToString(Character identity) {
            switch (identity.charValue()) {
                case '\u0001': {
                    return "HEADER_TABLE_SIZE";
                }
                case '\u0002': {
                    return "ENABLE_PUSH";
                }
                case '\u0003': {
                    return "MAX_CONCURRENT_STREAMS";
                }
                case '\u0004': {
                    return "INITIAL_WINDOW_SIZE";
                }
                case '\u0005': {
                    return "MAX_FRAME_SIZE";
                }
                case '\u0006': {
                    return "MAX_HEADER_LIST_SIZE";
                }
            }
            return "(0x" + Integer.toHexString(identity.charValue()) + ')';
        }

        @Nullable
        private static Integer toInteger(@Nullable Long value) {
            return value == null ? null : Integer.valueOf(value.intValue());
        }
    }
}

