/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractDelegatingHttpResponse;
import io.servicetalk.http.api.BlockingStreamingHttpMessageBodyUtils;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.DefaultStreamingHttpResponse;
import io.servicetalk.http.api.HttpMessageBodyIterable;
import io.servicetalk.http.api.HttpMessageBodyIterator;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.TrailersTransformer;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class DefaultBlockingStreamingHttpResponse
extends AbstractDelegatingHttpResponse
implements BlockingStreamingHttpResponse {
    @Nullable
    private InputStream inputStream;

    DefaultBlockingStreamingHttpResponse(DefaultStreamingHttpResponse original) {
        super(original);
    }

    @Override
    public BlockingIterable<Buffer> payloadBody() {
        return this.original.payloadBody().toIterable();
    }

    @Override
    public InputStream payloadBodyInputStream() {
        if (this.inputStream == null) {
            this.inputStream = BlockingStreamingHttpResponse.super.payloadBodyInputStream();
        }
        return this.inputStream;
    }

    @Override
    public <T> BlockingIterable<T> payloadBody(HttpStreamingDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody(), this.original.payloadHolder().allocator());
    }

    @Override
    public HttpMessageBodyIterable<Buffer> messageBody() {
        return BlockingStreamingHttpMessageBodyUtils.newMessageBody((BlockingIterable<Object>)this.original.messageBody().toIterable());
    }

    @Override
    public <T> HttpMessageBodyIterable<T> messageBody(HttpStreamingDeserializer<T> deserializer) {
        return BlockingStreamingHttpMessageBodyUtils.newMessageBody((BlockingIterable<Object>)this.original.messageBody().toIterable(), this.headers(), deserializer, this.original.payloadHolder().allocator());
    }

    @Override
    public BlockingStreamingHttpResponse payloadBody(Iterable<Buffer> payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromIterable(payloadBody));
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse payloadBody(InputStream payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromInputStream((InputStream)payloadBody, (arg_0, arg_1, arg_2) -> ((BufferAllocator)this.original.payloadHolder().allocator()).wrap(arg_0, arg_1, arg_2)));
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse messageBody(HttpMessageBodyIterable<Buffer> messageBody) {
        this.original.payloadHolder().messageBody(Publisher.defer(() -> {
            BlockingIterator body = messageBody.iterator();
            return Publisher.fromIterable(() -> DefaultBlockingStreamingHttpResponse.lambda$null$0((HttpMessageBodyIterator)body)).cast(Object.class).concat(Publisher.defer(() -> DefaultBlockingStreamingHttpResponse.lambda$null$1((HttpMessageBodyIterator)body)).shareContextOnSubscribe()).shareContextOnSubscribe();
        }));
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse messageBody(HttpMessageBodyIterable<T> messageBody, HttpStreamingSerializer<T> serializer) {
        this.original.payloadHolder().messageBody(Publisher.defer(() -> {
            BlockingIterator body = messageBody.iterator();
            return Publisher.from(serializer.serialize(this.headers(), () -> DefaultBlockingStreamingHttpResponse.lambda$null$3((HttpMessageBodyIterator)body), this.original.payloadHolder().allocator())).cast(Object.class).concat(Publisher.defer(() -> DefaultBlockingStreamingHttpResponse.lambda$null$4((HttpMessageBodyIterator)body)).shareContextOnSubscribe()).shareContextOnSubscribe();
        }));
        return this;
    }

    @Override
    @Deprecated
    public <T> BlockingStreamingHttpResponse payloadBody(Iterable<T> payloadBody, HttpSerializer<T> serializer) {
        this.original.payloadBody(Publisher.fromIterable(payloadBody), serializer);
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpResponse payloadBody(Iterable<T> payloadBody, HttpStreamingSerializer<T> serializer) {
        this.original.payloadBody(Publisher.fromIterable(payloadBody), serializer);
        return this;
    }

    @Override
    @Deprecated
    public <T> BlockingStreamingHttpResponse transformPayloadBody(Function<BlockingIterable<Buffer>, BlockingIterable<T>> transformer, HttpSerializer<T> serializer) {
        this.original.transformPayloadBody((Publisher<Buffer> bufferPublisher) -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))), serializer);
        return this;
    }

    @Override
    @Deprecated
    public BlockingStreamingHttpResponse transformPayloadBody(UnaryOperator<BlockingIterable<Buffer>> transformer) {
        this.original.transformPayloadBody(bufferPublisher -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))));
        return this;
    }

    @Override
    @Deprecated
    public <T> BlockingStreamingHttpResponse transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.original.transform(trailersTransformer);
        return this;
    }

    @Override
    public Single<HttpResponse> toResponse() {
        return this.toStreamingResponse().toResponse();
    }

    @Override
    public StreamingHttpResponse toStreamingResponse() {
        return this.original;
    }

    @Override
    public BlockingStreamingHttpResponse version(HttpProtocolVersion version) {
        this.original.version(version);
        return this;
    }

    @Override
    @Deprecated
    public BlockingStreamingHttpResponse encoding(ContentCodec encoding) {
        this.original.encoding(encoding);
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse context(ContextMap context) {
        this.original.context(context);
        return this;
    }

    @Override
    public BlockingStreamingHttpResponse status(HttpResponseStatus status) {
        this.original.status(status);
        return this;
    }

    static <T> Publisher<T> fromFilterNull(@Nullable T value) {
        return value == null ? Publisher.empty() : Publisher.from(value);
    }

    private static /* synthetic */ Publisher lambda$null$4(HttpMessageBodyIterator body) {
        return DefaultBlockingStreamingHttpResponse.fromFilterNull(body.trailers());
    }

    private static /* synthetic */ BlockingIterator lambda$null$3(HttpMessageBodyIterator body) {
        return body;
    }

    private static /* synthetic */ Publisher lambda$null$1(HttpMessageBodyIterator body) {
        return DefaultBlockingStreamingHttpResponse.fromFilterNull(body.trailers());
    }

    private static /* synthetic */ Iterator lambda$null$0(HttpMessageBodyIterator body) {
        return body;
    }
}

