/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.BlockingUtils;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLifecycleObserver;
import io.servicetalk.http.api.HttpProtocolConfig;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.HttpServiceBase;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.transport.api.ConnectionAcceptorFactory;
import io.servicetalk.transport.api.EarlyConnectionAcceptor;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.api.LateConnectionAcceptor;
import io.servicetalk.transport.api.ServerSslConfig;
import io.servicetalk.transport.api.TransportObserver;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public interface HttpServerBuilder {
    public HttpServerBuilder protocols(HttpProtocolConfig ... var1);

    public HttpServerBuilder sslConfig(ServerSslConfig var1);

    default public HttpServerBuilder sslConfig(ServerSslConfig config, boolean acceptInsecureConnections) {
        throw new UnsupportedOperationException("sslConfig(ServerSslConfig, boolean) is not supported by " + this.getClass());
    }

    public HttpServerBuilder sslConfig(ServerSslConfig var1, Map<String, ServerSslConfig> var2);

    default public HttpServerBuilder sslConfig(ServerSslConfig defaultConfig, Map<String, ServerSslConfig> sniMap, int maxClientHelloLength, Duration clientHelloTimeout) {
        throw new UnsupportedOperationException("sslConfig(ServerSslConfig, Map, int, Duration) is not supported by " + this.getClass());
    }

    public <T> HttpServerBuilder socketOption(SocketOption<T> var1, T var2);

    public <T> HttpServerBuilder listenSocketOption(SocketOption<T> var1, T var2);

    public HttpServerBuilder enableWireLogging(String var1, LogLevel var2, BooleanSupplier var3);

    public HttpServerBuilder transportObserver(TransportObserver var1);

    public HttpServerBuilder lifecycleObserver(HttpLifecycleObserver var1);

    public HttpServerBuilder drainRequestPayloadBody(boolean var1);

    public HttpServerBuilder allowDropRequestTrailers(boolean var1);

    @Deprecated
    default public HttpServerBuilder appendConnectionAcceptorFilter(ConnectionAcceptorFactory factory) {
        throw new UnsupportedOperationException("This method should not be implemented - consider using appendLateConnectionAcceptor instead");
    }

    default public HttpServerBuilder appendEarlyConnectionAcceptor(EarlyConnectionAcceptor acceptor) {
        throw new UnsupportedOperationException("appendEarlyConnectionAcceptor is not supported by " + this.getClass());
    }

    default public HttpServerBuilder appendLateConnectionAcceptor(LateConnectionAcceptor acceptor) {
        throw new UnsupportedOperationException("appendLateConnectionAcceptor is not supported by " + this.getClass());
    }

    public HttpServerBuilder appendNonOffloadingServiceFilter(StreamingHttpServiceFilterFactory var1);

    public HttpServerBuilder appendNonOffloadingServiceFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpServiceFilterFactory var2);

    public HttpServerBuilder appendServiceFilter(StreamingHttpServiceFilterFactory var1);

    public HttpServerBuilder appendServiceFilter(Predicate<StreamingHttpRequest> var1, StreamingHttpServiceFilterFactory var2);

    public HttpServerBuilder ioExecutor(IoExecutor var1);

    public HttpServerBuilder executor(Executor var1);

    public HttpServerBuilder bufferAllocator(BufferAllocator var1);

    public HttpServerBuilder executionStrategy(HttpExecutionStrategy var1);

    default public HttpServerContext listenServiceAndAwait(HttpServiceBase service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenService(service));
    }

    default public HttpServerContext listenAndAwait(HttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listen(service));
    }

    default public HttpServerContext listenStreamingAndAwait(StreamingHttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenStreaming(service));
    }

    default public HttpServerContext listenBlockingAndAwait(BlockingHttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenBlocking(service));
    }

    default public HttpServerContext listenBlockingStreamingAndAwait(BlockingStreamingHttpService service) throws Exception {
        return (HttpServerContext)BlockingUtils.blockingInvocation(this.listenBlockingStreaming(service));
    }

    default public Single<HttpServerContext> listenService(HttpServiceBase service) {
        if (service instanceof HttpService) {
            return this.listen((HttpService)service);
        }
        if (service instanceof StreamingHttpService) {
            return this.listenStreaming((StreamingHttpService)service);
        }
        if (service instanceof BlockingHttpService) {
            return this.listenBlocking((BlockingHttpService)service);
        }
        if (service instanceof BlockingStreamingHttpService) {
            return this.listenBlockingStreaming((BlockingStreamingHttpService)service);
        }
        return Single.failed((Throwable)new IllegalArgumentException("Unsupported service type: " + service));
    }

    public Single<HttpServerContext> listen(HttpService var1);

    public Single<HttpServerContext> listenStreaming(StreamingHttpService var1);

    public Single<HttpServerContext> listenBlocking(BlockingHttpService var1);

    public Single<HttpServerContext> listenBlockingStreaming(BlockingStreamingHttpService var1);
}

