/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingStreamingHttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpRequester;
import io.servicetalk.http.api.StreamingHttpConnection;
import java.util.concurrent.Future;

public interface HttpConnection
extends HttpRequester,
GracefulAutoCloseable {
    public HttpConnectionContext connectionContext();

    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> var1);

    public StreamingHttpConnection asStreamingConnection();

    default public BlockingStreamingHttpConnection asBlockingStreamingConnection() {
        return this.asStreamingConnection().asBlockingStreamingConnection();
    }

    default public BlockingHttpConnection asBlockingConnection() {
        return this.asStreamingConnection().asBlockingConnection();
    }

    default public void close() throws Exception {
        FutureUtils.awaitTermination((Future)this.closeAsync().toFuture());
    }

    default public void closeGracefully() throws Exception {
        FutureUtils.awaitTermination((Future)this.closeAsyncGracefully().toFuture());
    }
}

