/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.DefaultHttpSetCookie;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

final class ReadOnlyHttpHeaders
implements HttpHeaders {
    private final CharSequence[] keyValuePairs;
    private final boolean validateCookies;

    ReadOnlyHttpHeaders(CharSequence ... keyValuePairs) {
        this(true, keyValuePairs);
    }

    ReadOnlyHttpHeaders(boolean validateCookies, CharSequence ... keyValuePairs) {
        if ((keyValuePairs.length & 1) != 0) {
            throw new IllegalArgumentException("keyValuePairs length must be even but was: " + keyValuePairs.length);
        }
        this.keyValuePairs = Objects.requireNonNull(keyValuePairs);
        this.validateCookies = validateCookies;
    }

    private static int hashCode(CharSequence name) {
        return CharSequences.caseInsensitiveHashCode((CharSequence)name);
    }

    private static boolean equals(CharSequence name1, CharSequence name2) {
        return CharSequences.contentEqualsIgnoreCase((CharSequence)name1, (CharSequence)name2);
    }

    private static boolean equalsValues(CharSequence name1, CharSequence name2) {
        return CharSequences.contentEquals((CharSequence)name1, (CharSequence)name2);
    }

    @Override
    @Nullable
    public CharSequence get(CharSequence name) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(name);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            CharSequence currentName = this.keyValuePairs[i];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, name)) continue;
            return this.keyValuePairs[i + 1];
        }
        return null;
    }

    @Override
    @Nullable
    public CharSequence getAndRemove(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<? extends CharSequence> valuesIterator(CharSequence name) {
        return new ReadOnlyValueIterator(name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(name);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            CharSequence currentName = this.keyValuePairs[i];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, name) || !ReadOnlyHttpHeaders.equalsValues(this.keyValuePairs[i + 1], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsIgnoreCase(CharSequence name, CharSequence value) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(name);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            CharSequence currentName = this.keyValuePairs[i];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, name) || !ReadOnlyHttpHeaders.equals(this.keyValuePairs[i + 1], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keyValuePairs.length >>> 1;
    }

    @Override
    public boolean isEmpty() {
        return this.keyValuePairs.length == 0;
    }

    @Override
    public Set<? extends CharSequence> names() {
        HashSet<CharSequence> nameSet = new HashSet<CharSequence>(this.size());
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            nameSet.add(this.keyValuePairs[i]);
        }
        return Collections.unmodifiableSet(nameSet);
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders set(HttpHeaders headers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders replace(HttpHeaders headers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIgnoreCase(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return new ReadOnlyIterator();
    }

    public boolean equals(Object o) {
        return o instanceof HttpHeaders && HeaderUtils.equals(this, (HttpHeaders)o);
    }

    public int hashCode() {
        return HeaderUtils.hashCode(this);
    }

    @Override
    public String toString() {
        return this.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
    }

    @Override
    @Nullable
    public HttpCookiePair getCookie(CharSequence name) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(HttpHeaderNames.COOKIE);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            HttpCookiePair cookiePair;
            CharSequence currentName = this.keyValuePairs[i];
            CharSequence currentValue = this.keyValuePairs[i + 1];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, HttpHeaderNames.COOKIE) || (cookiePair = HeaderUtils.parseCookiePair(currentValue, name)) == null) continue;
            return cookiePair;
        }
        return null;
    }

    @Override
    @Nullable
    public HttpSetCookie getSetCookie(CharSequence name) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(HttpHeaderNames.SET_COOKIE);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            HttpSetCookie setCookie;
            CharSequence currentName = this.keyValuePairs[i];
            CharSequence currentValue = this.keyValuePairs[i + 1];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, HttpHeaderNames.SET_COOKIE) || (setCookie = HeaderUtils.parseSetCookie(currentValue, name, this.validateCookies)) == null) continue;
            return setCookie;
        }
        return null;
    }

    @Override
    public Iterator<? extends HttpCookiePair> getCookiesIterator() {
        Iterator<? extends CharSequence> valueItr = this.valuesIterator(HttpHeaderNames.COOKIE);
        return valueItr.hasNext() ? new ReadOnlyCookiesIterator(valueItr) : Collections.emptyIterator();
    }

    @Override
    public Iterator<? extends HttpCookiePair> getCookiesIterator(CharSequence name) {
        return new ReadOnlyCookiesByNameIterator(this.valuesIterator(HttpHeaderNames.COOKIE), name);
    }

    @Override
    public Iterator<? extends HttpSetCookie> getSetCookiesIterator() {
        int nameHash = ReadOnlyHttpHeaders.hashCode(HttpHeaderNames.SET_COOKIE);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            CharSequence currentName = this.keyValuePairs[i];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, HttpHeaderNames.SET_COOKIE)) continue;
            return new ReadOnlySetCookieIterator(i, nameHash, this.validateCookies);
        }
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence name) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(HttpHeaderNames.SET_COOKIE);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            HttpSetCookie setCookie;
            CharSequence currentName = this.keyValuePairs[i];
            CharSequence currentValue = this.keyValuePairs[i + 1];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, HttpHeaderNames.SET_COOKIE) || (setCookie = HeaderUtils.parseSetCookie(currentValue, name, this.validateCookies)) == null) continue;
            return new ReadOnlySetCookieNameIterator(i, nameHash, setCookie);
        }
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence name, CharSequence domain, CharSequence path) {
        int nameHash = ReadOnlyHttpHeaders.hashCode(HttpHeaderNames.SET_COOKIE);
        int end = this.keyValuePairs.length - 1;
        for (int i = 0; i < end; i += 2) {
            HttpSetCookie setCookie;
            CharSequence currentName = this.keyValuePairs[i];
            CharSequence currentValue = this.keyValuePairs[i + 1];
            if (nameHash != ReadOnlyHttpHeaders.hashCode(currentName) || !ReadOnlyHttpHeaders.equals(currentName, HttpHeaderNames.SET_COOKIE) || (setCookie = HeaderUtils.parseSetCookie(currentValue, name, this.validateCookies)) == null || !HeaderUtils.domainMatches(domain, setCookie.domain()) || !HeaderUtils.pathMatches(path, setCookie.path())) continue;
            return new ReadOnlySetCookieNameDomainPathIterator(i, nameHash, setCookie, domain, path);
        }
        return Collections.emptyIterator();
    }

    @Override
    public HttpHeaders addCookie(HttpCookiePair cookie) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HttpHeaders addSetCookie(HttpSetCookie cookie) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeCookies(CharSequence name) {
        return false;
    }

    @Override
    public boolean removeSetCookies(CharSequence name) {
        return false;
    }

    @Override
    public boolean removeSetCookies(CharSequence name, CharSequence domain, CharSequence path) {
        return false;
    }

    private final class ReadOnlyValueIterator
    implements Iterator<CharSequence> {
        private final CharSequence name;
        private final int nameHash;
        private int keyIndex;
        @Nullable
        private CharSequence nextValue;

        ReadOnlyValueIterator(CharSequence name) {
            this.name = name;
            this.nameHash = ReadOnlyHttpHeaders.hashCode(name);
            this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public CharSequence next() {
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            CharSequence current = this.nextValue;
            this.calculateNext();
            return current;
        }

        private void calculateNext() {
            int end = ReadOnlyHttpHeaders.this.keyValuePairs.length - 1;
            while (this.keyIndex < end) {
                CharSequence currentName = ReadOnlyHttpHeaders.this.keyValuePairs[this.keyIndex];
                if (this.nameHash == ReadOnlyHttpHeaders.hashCode(currentName) && ReadOnlyHttpHeaders.equals(this.name, currentName)) {
                    this.nextValue = ReadOnlyHttpHeaders.this.keyValuePairs[this.keyIndex + 1];
                    this.keyIndex += 2;
                    return;
                }
                this.keyIndex += 2;
            }
            this.nextValue = null;
        }
    }

    private final class ReadOnlyIterator
    implements Map.Entry<CharSequence, CharSequence>,
    Iterator<Map.Entry<CharSequence, CharSequence>> {
        private int keyIndex;
        @Nullable
        private CharSequence key;
        @Nullable
        private CharSequence value;

        private ReadOnlyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.keyIndex != ReadOnlyHttpHeaders.this.keyValuePairs.length;
        }

        @Override
        public Map.Entry<CharSequence, CharSequence> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.key = ReadOnlyHttpHeaders.this.keyValuePairs[this.keyIndex];
            this.value = ReadOnlyHttpHeaders.this.keyValuePairs[this.keyIndex + 1];
            this.keyIndex += 2;
            return this;
        }

        @Override
        @Nullable
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        @Nullable
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public CharSequence setValue(CharSequence value) {
            throw new UnsupportedOperationException();
        }
    }

    private final class ReadOnlySetCookieNameDomainPathIterator
    implements Iterator<HttpSetCookie> {
        private final int nameHash;
        private final CharSequence domain;
        private final CharSequence path;
        @Nullable
        private HttpSetCookie next;
        private int i;

        ReadOnlySetCookieNameDomainPathIterator(int keyIndex, int nameHash, HttpSetCookie next, CharSequence domain, CharSequence path) {
            this.i = keyIndex;
            this.nameHash = nameHash;
            this.domain = domain;
            this.path = path;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpSetCookie currentCookie = this.next;
            this.next = null;
            this.i += 2;
            int end = ReadOnlyHttpHeaders.this.keyValuePairs.length - 1;
            while (this.i < end) {
                HttpSetCookie setCookie;
                CharSequence currentName = ReadOnlyHttpHeaders.this.keyValuePairs[this.i];
                CharSequence currentValue = ReadOnlyHttpHeaders.this.keyValuePairs[this.i + 1];
                if (this.nameHash == CharSequences.caseInsensitiveHashCode((CharSequence)currentName) && CharSequences.contentEqualsIgnoreCase((CharSequence)currentName, (CharSequence)HttpHeaderNames.SET_COOKIE) && (setCookie = HeaderUtils.parseSetCookie(currentValue, currentCookie.name(), ReadOnlyHttpHeaders.this.validateCookies)) != null && HeaderUtils.domainMatches(this.domain, setCookie.domain()) && HeaderUtils.pathMatches(this.path, setCookie.path())) {
                    this.next = setCookie;
                    break;
                }
                this.i += 2;
            }
            return currentCookie;
        }
    }

    private final class ReadOnlySetCookieNameIterator
    implements Iterator<HttpSetCookie> {
        private final int nameHash;
        @Nullable
        private HttpSetCookie next;
        private int i;

        ReadOnlySetCookieNameIterator(int keyIndex, int nameHash, HttpSetCookie next) {
            this.i = keyIndex;
            this.nameHash = nameHash;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpSetCookie currentCookie = this.next;
            this.next = null;
            this.i += 2;
            int end = ReadOnlyHttpHeaders.this.keyValuePairs.length - 1;
            while (this.i < end) {
                CharSequence currentName = ReadOnlyHttpHeaders.this.keyValuePairs[this.i];
                CharSequence currentValue = ReadOnlyHttpHeaders.this.keyValuePairs[this.i + 1];
                if (this.nameHash == CharSequences.caseInsensitiveHashCode((CharSequence)currentName) && CharSequences.contentEqualsIgnoreCase((CharSequence)currentName, (CharSequence)HttpHeaderNames.SET_COOKIE)) {
                    this.next = HeaderUtils.parseSetCookie(currentValue, currentCookie.name(), ReadOnlyHttpHeaders.this.validateCookies);
                    if (this.next != null) break;
                }
                this.i += 2;
            }
            return currentCookie;
        }
    }

    private final class ReadOnlySetCookieIterator
    implements Iterator<HttpSetCookie> {
        private final int nameHash;
        private final boolean validate;
        private int i;

        ReadOnlySetCookieIterator(int keyIndex, int nameHash, boolean validate) {
            this.i = keyIndex;
            this.nameHash = nameHash;
            this.validate = validate;
        }

        @Override
        public boolean hasNext() {
            return this.i < ReadOnlyHttpHeaders.this.keyValuePairs.length;
        }

        @Override
        public HttpSetCookie next() {
            CharSequence currentName;
            int end = ReadOnlyHttpHeaders.this.keyValuePairs.length - 1;
            if (this.i >= end) {
                throw new NoSuchElementException();
            }
            HttpSetCookie next = DefaultHttpSetCookie.parseSetCookie(ReadOnlyHttpHeaders.this.keyValuePairs[this.i + 1], this.validate);
            this.i += 2;
            while (!(this.i >= end || this.nameHash == CharSequences.caseInsensitiveHashCode((CharSequence)(currentName = ReadOnlyHttpHeaders.this.keyValuePairs[this.i])) && CharSequences.contentEqualsIgnoreCase((CharSequence)currentName, (CharSequence)HttpHeaderNames.SET_COOKIE))) {
                this.i += 2;
            }
            return next;
        }
    }

    private static final class ReadOnlyCookiesByNameIterator
    extends HeaderUtils.CookiesByNameIterator {
        private final Iterator<? extends CharSequence> valueItr;
        @Nullable
        private CharSequence headerValue;

        ReadOnlyCookiesByNameIterator(Iterator<? extends CharSequence> valueItr, CharSequence name) {
            super(name);
            this.valueItr = valueItr;
            if (valueItr.hasNext()) {
                this.headerValue = valueItr.next();
                this.initNext(this.headerValue);
            }
        }

        @Override
        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.headerValue;
        }

        @Override
        protected void advanceCookieHeaderValue() {
            this.headerValue = this.valueItr.hasNext() ? this.valueItr.next() : null;
        }
    }

    private static final class ReadOnlyCookiesIterator
    extends HeaderUtils.CookiesIterator {
        private final Iterator<? extends CharSequence> valueItr;
        @Nullable
        private CharSequence headerValue;

        ReadOnlyCookiesIterator(Iterator<? extends CharSequence> valueItr) {
            this.valueItr = valueItr;
            if (valueItr.hasNext()) {
                this.headerValue = valueItr.next();
                this.initNext(this.headerValue);
            }
        }

        @Override
        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.headerValue;
        }

        @Override
        protected void advanceCookieHeaderValue() {
            this.headerValue = this.valueItr.hasNext() ? this.valueItr.next() : null;
        }
    }
}

