/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpRequestResponseFactory;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpRequestFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.concurrent.ExecutionException;

final class RequestResponseFactories {
    private RequestResponseFactories() {
    }

    static BlockingStreamingHttpRequestResponseFactory toBlockingStreaming(StreamingHttpRequestResponseFactory reqRespFactory) {
        return new StreamingHttpRequestResponseFactoryToBlockingStreamingHttpRequestResponseFactory(reqRespFactory);
    }

    static BlockingStreamingHttpRequestResponseFactory toBlockingStreaming(StreamingHttpRequester requester) {
        return new StreamingHttpRequesterToBlockingStreamingHttpRequestResponseFactory(requester);
    }

    static HttpRequestResponseFactory toAggregated(StreamingHttpRequestResponseFactory reqRespFactory) {
        return new StreamingHttpRequestResponseFactoryToHttpRequestResponseFactory(reqRespFactory);
    }

    static HttpRequestResponseFactory toAggregated(StreamingHttpRequester requester) {
        return new StreamingHttpRequesterToHttpRequestResponseFactory(requester);
    }

    private static HttpRequest newRequestBlocking(StreamingHttpRequestFactory requestFactory, HttpRequestMethod method, String requestTarget) {
        try {
            return (HttpRequest)requestFactory.newRequest(method, requestTarget).toRequest().toFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return (HttpRequest)PlatformDependent.throwException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static HttpResponse newResponseBlocking(StreamingHttpResponseFactory responseFactory, HttpResponseStatus status) {
        try {
            return (HttpResponse)responseFactory.newResponse(status).toResponse().toFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class StreamingHttpRequestResponseFactoryToHttpRequestResponseFactory
    implements HttpRequestResponseFactory {
        private final StreamingHttpRequestResponseFactory reqRespFactory;

        StreamingHttpRequestResponseFactoryToHttpRequestResponseFactory(StreamingHttpRequestResponseFactory reqRespFactory) {
            this.reqRespFactory = reqRespFactory;
        }

        @Override
        public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return RequestResponseFactories.newRequestBlocking(this.reqRespFactory, method, requestTarget);
        }

        @Override
        public HttpResponse newResponse(HttpResponseStatus status) {
            return RequestResponseFactories.newResponseBlocking(this.reqRespFactory, status);
        }
    }

    private static final class StreamingHttpRequesterToHttpRequestResponseFactory
    implements HttpRequestResponseFactory {
        private final StreamingHttpRequester requester;

        private StreamingHttpRequesterToHttpRequestResponseFactory(StreamingHttpRequester requester) {
            this.requester = requester;
        }

        @Override
        public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return RequestResponseFactories.newRequestBlocking(this.requester, method, requestTarget);
        }

        @Override
        public HttpResponse newResponse(HttpResponseStatus status) {
            return RequestResponseFactories.newResponseBlocking(this.requester.httpResponseFactory(), status);
        }
    }

    private static final class StreamingHttpRequestResponseFactoryToBlockingStreamingHttpRequestResponseFactory
    implements BlockingStreamingHttpRequestResponseFactory {
        private final StreamingHttpRequestResponseFactory reqRespFactory;

        StreamingHttpRequestResponseFactoryToBlockingStreamingHttpRequestResponseFactory(StreamingHttpRequestResponseFactory reqRespFactory) {
            this.reqRespFactory = reqRespFactory;
        }

        @Override
        public BlockingStreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget).toBlockingStreamingRequest();
        }

        @Override
        public BlockingStreamingHttpResponse newResponse(HttpResponseStatus status) {
            return this.reqRespFactory.newResponse(status).toBlockingStreamingResponse();
        }
    }

    private static final class StreamingHttpRequesterToBlockingStreamingHttpRequestResponseFactory
    implements BlockingStreamingHttpRequestResponseFactory {
        private final StreamingHttpRequester requester;

        private StreamingHttpRequesterToBlockingStreamingHttpRequestResponseFactory(StreamingHttpRequester requester) {
            this.requester = requester;
        }

        @Override
        public BlockingStreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.requester.newRequest(method, requestTarget).toBlockingStreamingRequest();
        }

        @Override
        public BlockingStreamingHttpResponse newResponse(HttpResponseStatus status) {
            return this.requester.httpResponseFactory().newResponse(status).toBlockingStreamingResponse();
        }
    }
}

