/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.DefaultHttpExecutionStrategy;
import io.servicetalk.http.api.DelegatingHttpConnectionContext;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpRequestResponseFactory;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.RequestResponseFactories;
import io.servicetalk.http.api.StreamingHttpConnection;

final class StreamingHttpConnectionToBlockingHttpConnection
implements BlockingHttpConnection {
    static final HttpExecutionStrategy DEFAULT_BLOCKING_CONNECTION_STRATEGY = DefaultHttpExecutionStrategy.OFFLOAD_EVENT_STRATEGY;
    private final StreamingHttpConnection connection;
    private final HttpExecutionStrategy strategy;
    private final HttpConnectionContext context;
    private final HttpExecutionContext executionContext;
    private final HttpRequestResponseFactory reqRespFactory;

    StreamingHttpConnectionToBlockingHttpConnection(StreamingHttpConnection connection, HttpExecutionStrategy strategy) {
        this.strategy = HttpExecutionStrategies.defaultStrategy() == strategy ? DEFAULT_BLOCKING_CONNECTION_STRATEGY : strategy;
        this.connection = connection;
        HttpConnectionContext originalCtx = connection.connectionContext();
        this.executionContext = new DelegatingHttpExecutionContext(connection.executionContext()){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return StreamingHttpConnectionToBlockingHttpConnection.this.strategy;
            }
        };
        this.context = new DelegatingHttpConnectionContext(originalCtx){

            @Override
            public HttpExecutionContext executionContext() {
                return StreamingHttpConnectionToBlockingHttpConnection.this.executionContext;
            }
        };
        this.reqRespFactory = RequestResponseFactories.toAggregated(connection);
    }

    @Override
    public HttpConnectionContext connectionContext() {
        return this.context;
    }

    @Override
    public <T> BlockingIterable<? extends T> transportEventIterable(HttpEventKey<T> eventKey) {
        return this.connection.transportEventStream(eventKey).toIterable();
    }

    @Override
    public StreamingHttpConnection asStreamingConnection() {
        return this.connection;
    }

    @Override
    public HttpResponse request(HttpRequest request) throws Exception {
        return BlockingUtils.request(this.connection, request);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public HttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    public void closeGracefully() throws Exception {
        this.connection.closeGracefully();
    }

    @Override
    public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }
}

