/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ReadOnlyBufferAllocators;
import io.servicetalk.http.api.BufferUtils;
import java.util.Objects;
import javax.annotation.Nullable;

public final class HttpRequestMethod
implements Comparable<HttpRequestMethod> {
    public static final HttpRequestMethod GET = new HttpRequestMethod("GET", Properties.SAFE_IDEMPOTENT_CACHEABLE);
    public static final HttpRequestMethod HEAD = new HttpRequestMethod("HEAD", Properties.SAFE_IDEMPOTENT_CACHEABLE);
    public static final HttpRequestMethod POST = new HttpRequestMethod("POST", Properties.CACHEABLE);
    public static final HttpRequestMethod PUT = new HttpRequestMethod("PUT", Properties.IDEMPOTENT);
    public static final HttpRequestMethod DELETE = new HttpRequestMethod("DELETE", Properties.IDEMPOTENT);
    public static final HttpRequestMethod CONNECT = new HttpRequestMethod("CONNECT", Properties.NONE);
    public static final HttpRequestMethod OPTIONS = new HttpRequestMethod("OPTIONS", Properties.SAFE_IDEMPOTENT);
    public static final HttpRequestMethod TRACE = new HttpRequestMethod("TRACE", Properties.SAFE_IDEMPOTENT);
    public static final HttpRequestMethod PATCH = new HttpRequestMethod("PATCH", Properties.NONE);
    private final String name;
    private final Properties properties;
    private final Buffer encodedAsBuffer;

    private HttpRequestMethod(String name, Properties properties) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Method name cannot be empty");
        }
        this.name = name;
        this.properties = Objects.requireNonNull(properties);
        this.encodedAsBuffer = ReadOnlyBufferAllocators.PREFER_HEAP_RO_ALLOCATOR.fromAscii((CharSequence)name);
    }

    public static HttpRequestMethod of(String name, Properties properties) {
        return new HttpRequestMethod(name, properties);
    }

    @Nullable
    public static HttpRequestMethod of(String name) {
        switch (name) {
            case "GET": {
                return GET;
            }
            case "HEAD": {
                return HEAD;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "DELETE": {
                return DELETE;
            }
            case "CONNECT": {
                return CONNECT;
            }
            case "OPTIONS": {
                return OPTIONS;
            }
            case "TRACE": {
                return TRACE;
            }
            case "PATCH": {
                return PATCH;
            }
        }
        return null;
    }

    public void writeTo(Buffer buffer) {
        BufferUtils.writeReadOnlyBuffer(this.encodedAsBuffer, buffer);
    }

    public String name() {
        return this.name;
    }

    public Properties properties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRequestMethod)) {
            return false;
        }
        HttpRequestMethod that = (HttpRequestMethod)o;
        return this.name.equals(that.name());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(HttpRequestMethod anotherMethod) {
        return this.name.compareTo(anotherMethod.name);
    }

    public String toString() {
        return this.name;
    }

    public static final class Properties {
        public static final Properties SAFE_IDEMPOTENT_CACHEABLE = new Properties(true, true, true);
        public static final Properties SAFE_IDEMPOTENT = new Properties(true, true, false);
        public static final Properties IDEMPOTENT = new Properties(false, true, false);
        public static final Properties CACHEABLE = new Properties(false, false, true);
        public static final Properties NONE = new Properties(false, false, false);
        private final boolean safe;
        private final boolean idempotent;
        private final boolean cacheable;

        private Properties(boolean safe, boolean idempotent, boolean cacheable) {
            this.safe = safe;
            this.idempotent = idempotent;
            this.cacheable = cacheable;
        }

        public static Properties newRequestMethodProperties(boolean safe, boolean idempotent, boolean cacheable) {
            return new Properties(safe, idempotent, cacheable);
        }

        public boolean isSafe() {
            return this.safe;
        }

        public boolean isIdempotent() {
            return this.idempotent;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties that = (Properties)o;
            return this.safe == that.isSafe() && this.idempotent == that.isIdempotent() && this.cacheable == that.isCacheable();
        }

        public int hashCode() {
            int result = this.safe ? 1 : 0;
            result = 31 * result + (this.idempotent ? 1 : 0);
            result = 31 * result + (this.cacheable ? 1 : 0);
            return result;
        }
    }
}

