/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.http.api.BlockingStreamingHttpServerResponse;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;

final class DefaultBlockingStreamingHttpServerResponse
extends BlockingStreamingHttpServerResponse {
    private static final AtomicIntegerFieldUpdater<DefaultBlockingStreamingHttpServerResponse> metaSentUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultBlockingStreamingHttpServerResponse.class, "metaSent");
    private volatile int metaSent;
    private final Consumer<HttpResponseMetaData> sendMeta;

    DefaultBlockingStreamingHttpServerResponse(HttpResponseStatus status, HttpProtocolVersion version, HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator, Consumer<HttpResponseMetaData> sendMeta) {
        super(status, version, headers, payloadWriter, allocator);
        this.sendMeta = sendMeta;
    }

    @Override
    public BlockingStreamingHttpServerResponse version(HttpProtocolVersion version) {
        this.checkSent();
        return super.version(version);
    }

    @Override
    public BlockingStreamingHttpServerResponse status(HttpResponseStatus status) {
        this.checkSent();
        return super.status(status);
    }

    @Override
    public BlockingStreamingHttpServerResponse addHeader(CharSequence name, CharSequence value) {
        this.checkSent();
        return super.addHeader(name, value);
    }

    @Override
    public BlockingStreamingHttpServerResponse addHeaders(HttpHeaders headers) {
        this.checkSent();
        return super.addHeaders(headers);
    }

    @Override
    public BlockingStreamingHttpServerResponse setHeader(CharSequence name, CharSequence value) {
        this.checkSent();
        return super.setHeader(name, value);
    }

    @Override
    public BlockingStreamingHttpServerResponse setHeaders(HttpHeaders headers) {
        this.checkSent();
        return super.setHeaders(headers);
    }

    @Override
    public BlockingStreamingHttpServerResponse addCookie(HttpCookiePair cookie) {
        this.checkSent();
        return super.addCookie(cookie);
    }

    @Override
    public BlockingStreamingHttpServerResponse addCookie(CharSequence name, CharSequence value) {
        this.checkSent();
        return super.addCookie(name, value);
    }

    @Override
    public BlockingStreamingHttpServerResponse addSetCookie(HttpSetCookie cookie) {
        this.checkSent();
        return super.addSetCookie(cookie);
    }

    @Override
    public BlockingStreamingHttpServerResponse addSetCookie(CharSequence name, CharSequence value) {
        this.checkSent();
        return super.addSetCookie(name, value);
    }

    private void checkSent() {
        if (this.metaSent != 0) {
            DefaultBlockingStreamingHttpServerResponse.throwMetaAlreadySent();
        }
    }

    @Override
    public HttpPayloadWriter<Buffer> sendMetaData() {
        if (!this.markMetaSent()) {
            DefaultBlockingStreamingHttpServerResponse.throwMetaAlreadySent();
        }
        this.sendMeta.accept(this);
        return this.payloadWriter();
    }

    boolean markMetaSent() {
        return metaSentUpdater.compareAndSet(this, 0, 1);
    }

    private static void throwMetaAlreadySent() {
        throw new IllegalStateException("Response meta-data is already sent");
    }
}

