/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.AbstractHttpMetaData;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpQuery;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpUri;
import io.servicetalk.http.api.QueryStringDecoder;
import io.servicetalk.http.api.QueryStringEncoder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class DefaultHttpRequestMetaData
extends AbstractHttpMetaData
implements HttpRequestMetaData {
    private static final Charset REQUEST_TARGET_CHARSET = StandardCharsets.UTF_8;
    private static final int PORT_NOT_ASSIGNED = -2;
    private HttpRequestMethod method;
    private String requestTarget;
    @Nullable
    private HttpQuery httpQuery;
    @Nullable
    private HttpUri requestTargetUri;
    @Nullable
    private String effectiveRequestHost;
    private int effectiveRequestPort = -2;
    @Nullable
    private CharSequence effectiveRequestHostHeader;

    DefaultHttpRequestMetaData(HttpRequestMethod method, String requestTarget, HttpProtocolVersion version, HttpHeaders headers) {
        super(version, headers);
        this.method = Objects.requireNonNull(method);
        this.requestTarget = Objects.requireNonNull(requestTarget);
    }

    DefaultHttpRequestMetaData(DefaultHttpRequestMetaData requestMetaData) {
        super(requestMetaData);
        this.method = requestMetaData.method;
        this.requestTarget = requestMetaData.requestTarget;
        this.httpQuery = requestMetaData.httpQuery;
        this.requestTargetUri = requestMetaData.requestTargetUri;
        this.effectiveRequestHost = requestMetaData.effectiveRequestHost;
        this.effectiveRequestPort = requestMetaData.effectiveRequestPort;
        this.effectiveRequestHostHeader = requestMetaData.effectiveRequestHostHeader;
    }

    @Override
    public HttpRequestMetaData version(HttpProtocolVersion version) {
        super.version(version);
        return this;
    }

    @Override
    public final HttpRequestMethod method() {
        return this.method;
    }

    @Override
    public HttpRequestMetaData method(HttpRequestMethod method) {
        this.method = Objects.requireNonNull(method);
        return this;
    }

    @Override
    public final String requestTarget() {
        return this.requestTarget;
    }

    @Override
    public HttpRequestMetaData requestTarget(String requestTarget) {
        this.requestTarget = Objects.requireNonNull(requestTarget);
        this.invalidateParsedUri();
        return this;
    }

    @Override
    @Nullable
    public final String scheme() {
        return this.lazyParseRequestTarget().scheme();
    }

    @Override
    @Nullable
    public final String userInfo() {
        return this.lazyParseRequestTarget().userInfo();
    }

    @Override
    @Nullable
    public final String host() {
        return this.lazyParseRequestTarget().host();
    }

    @Override
    public final int port() {
        return this.lazyParseRequestTarget().explicitPort();
    }

    @Override
    public final String rawPath() {
        return this.lazyParseRequestTarget().rawPath();
    }

    @Override
    public HttpRequestMetaData rawPath(String path) {
        if (!path.isEmpty() && path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must be empty or start with '/'");
        }
        this.requestTarget(this.encodeRequestTarget(path, this.rawQuery(), null));
        return this;
    }

    @Override
    public final String path() {
        return this.lazyParseRequestTarget().path();
    }

    @Override
    public HttpRequestMetaData path(String path) {
        if (!path.isEmpty() && path.charAt(0) != '/') {
            path = "/" + path;
        }
        String encodedPath = DefaultHttpRequestMetaData.urlEncode(path).replaceAll("%2F", "/");
        this.requestTarget(this.encodeRequestTarget(encodedPath, this.rawQuery(), null));
        return this;
    }

    @Override
    public HttpRequestMetaData appendPathSegments(String ... segments) {
        if (segments.length == 0) {
            throw new IllegalArgumentException("At least one path segment must be provided");
        }
        String path = this.path();
        StringBuilder builder = new StringBuilder(path.length() + 8 * segments.length).append(path);
        if (!path.isEmpty() && !path.endsWith("/")) {
            builder.append('/');
        }
        for (int i = 0; i < segments.length; ++i) {
            builder.append(DefaultHttpRequestMetaData.urlEncode(segments[i]));
            if (i >= segments.length - 1) continue;
            builder.append('/');
        }
        this.requestTarget(this.encodeRequestTarget(builder.toString(), this.rawQuery(), null));
        return this;
    }

    @Override
    public final String rawQuery() {
        return this.lazyParseRequestTarget().rawQuery();
    }

    @Override
    public HttpRequestMetaData rawQuery(String query) {
        this.requestTarget(this.encodeRequestTarget(this.rawPath(), Objects.requireNonNull(query), null));
        return this;
    }

    @Override
    @Nullable
    public String queryParameter(String key) {
        return this.lazyParseQueryString().get(key);
    }

    @Override
    public Iterable<Map.Entry<String, String>> queryParameters() {
        return this.lazyParseQueryString();
    }

    @Override
    public Iterable<String> queryParameters(String key) {
        return this.lazyParseQueryString().values(key);
    }

    @Override
    public Iterator<String> queryParametersIterator(String key) {
        return this.lazyParseQueryString().valuesIterator(key);
    }

    @Override
    public Set<String> queryParametersKeys() {
        return this.lazyParseQueryString().keys();
    }

    @Override
    public boolean hasQueryParameter(String key, String value) {
        return this.lazyParseQueryString().contains(key, value);
    }

    @Override
    public int queryParametersSize() {
        return this.lazyParseQueryString().size();
    }

    @Override
    public HttpRequestMetaData addQueryParameter(String key, String value) {
        this.lazyParseQueryString().add(key, value);
        return this;
    }

    @Override
    public HttpRequestMetaData addQueryParameters(String key, Iterable<String> values) {
        this.lazyParseQueryString().add(key, values);
        return this;
    }

    @Override
    public HttpRequestMetaData addQueryParameters(String key, String ... values) {
        this.lazyParseQueryString().add(key, values);
        return this;
    }

    @Override
    public HttpRequestMetaData setQueryParameter(String key, String value) {
        this.lazyParseQueryString().set(key, value);
        return this;
    }

    @Override
    public HttpRequestMetaData setQueryParameters(String key, Iterable<String> values) {
        this.lazyParseQueryString().set(key, values);
        return this;
    }

    @Override
    public HttpRequestMetaData setQueryParameters(String key, String ... values) {
        this.lazyParseQueryString().set(key, values);
        return this;
    }

    @Override
    public boolean removeQueryParameters(String key) {
        return this.lazyParseQueryString().remove(key);
    }

    @Override
    public boolean removeQueryParameters(String key, String value) {
        return this.lazyParseQueryString().remove(key, value);
    }

    @Override
    @Nullable
    public final String effectiveHost() {
        this.lazyParseEffectiveRequest();
        return this.effectiveRequestHost;
    }

    @Override
    public final int effectivePort() {
        this.lazyParseEffectiveRequest();
        return this.effectiveRequestPort;
    }

    private HttpQuery lazyParseQueryString() {
        if (this.httpQuery == null) {
            this.httpQuery = new HttpQuery(QueryStringDecoder.decodeParams(this.lazyParseRequestTarget().rawQuery()), this::setQueryParams);
        }
        return this.httpQuery;
    }

    private HttpUri lazyParseRequestTarget() {
        if (this.requestTargetUri == null) {
            this.requestTargetUri = new HttpUri(this.requestTarget());
        }
        return this.requestTargetUri;
    }

    private void lazyParseEffectiveRequest() {
        CharSequence hostHeader = this.headers().get(HttpHeaderNames.HOST);
        if (this.effectiveRequestPort == -2 || !Objects.equals(hostHeader, this.effectiveRequestHostHeader)) {
            HttpUri effectiveRequestUri = new HttpUri(this.requestTarget(), () -> hostHeader != null ? hostHeader.toString() : null);
            this.effectiveRequestHost = effectiveRequestUri.host();
            this.effectiveRequestPort = effectiveRequestUri.explicitPort();
            this.effectiveRequestHostHeader = hostHeader;
        }
    }

    void setQueryParams(Map<String, List<String>> params) {
        QueryStringEncoder encoder = new QueryStringEncoder(this.rawPath());
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            for (String value : entry.getValue()) {
                encoder.addParam(entry.getKey(), value);
            }
        }
        this.requestTarget(this.encodeRequestTarget(null, null, encoder.toString()));
    }

    private String encodeRequestTarget(@Nullable String path, @Nullable String query, @Nullable String relativeReference) {
        HttpUri uri = this.lazyParseRequestTarget();
        String scheme = uri.scheme();
        return HttpUri.buildRequestTarget(scheme != null ? scheme : "http", uri.host(), uri.explicitPort(), path, query, relativeReference);
    }

    private void invalidateParsedUri() {
        this.requestTargetUri = null;
        this.effectiveRequestPort = -2;
        this.effectiveRequestHost = null;
        this.effectiveRequestHostHeader = null;
        this.httpQuery = null;
    }

    @Override
    public final String toString() {
        return this.method().toString() + " " + this.requestTarget() + " " + this.version();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultHttpRequestMetaData that = (DefaultHttpRequestMetaData)o;
        return this.method.equals(that.method) && this.requestTarget.equals(that.requestTarget);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.requestTarget.hashCode();
        return result;
    }

    private static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, REQUEST_TARGET_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(REQUEST_TARGET_CHARSET.name());
        }
    }
}

