/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DelegatingToBufferHttpPayloadWriter;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpPayloadWriter;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.serialization.api.Serializer;
import io.servicetalk.serialization.api.TypeHolder;
import java.io.IOException;
import java.util.function.Consumer;

final class DefaultTypeHttpSerializer<T>
implements HttpSerializer<T> {
    private final Consumer<HttpHeaders> addContentType;
    private final Serializer serializer;
    private final TypeHolder<T> type;

    DefaultTypeHttpSerializer(TypeHolder<T> type, Serializer serializer, Consumer<HttpHeaders> addContentType) {
        this.addContentType = addContentType;
        this.serializer = serializer;
        this.type = type;
    }

    @Override
    public Buffer serialize(HttpHeaders headers, T value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return this.serializer.serialize(value, allocator);
    }

    @Override
    public BlockingIterable<Buffer> serialize(HttpHeaders headers, BlockingIterable<T> value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return this.serializer.serialize(value, allocator, this.type);
    }

    @Override
    public Publisher<Buffer> serialize(HttpHeaders headers, Publisher<T> value, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return this.serializer.serialize(value, allocator, this.type);
    }

    @Override
    public HttpPayloadWriter<T> serialize(HttpHeaders headers, HttpPayloadWriter<Buffer> payloadWriter, BufferAllocator allocator) {
        this.addContentType.accept(headers);
        return new DelegatingToBufferHttpPayloadWriter<T>(payloadWriter, allocator){

            public void write(T object) throws IOException {
                this.delegate.write(DefaultTypeHttpSerializer.this.serializer.serialize(object, this.allocator));
            }
        };
    }
}

