/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.PayloadInfo;

final class DefaultPayloadInfo
implements PayloadInfo {
    private static final byte SAFE_TO_AGGREGATE = 1;
    private static final byte MAY_HAVE_TRAILERS = 2;
    private static final byte ONLY_EMIT_BUFFERS = 4;
    private byte flags;

    DefaultPayloadInfo() {
    }

    DefaultPayloadInfo(PayloadInfo from) {
        if (from instanceof DefaultPayloadInfo) {
            this.flags = ((DefaultPayloadInfo)from).flags;
        } else {
            this.setSafeToAggregate(from.isSafeToAggregate());
            this.setMayHaveTrailers(from.mayHaveTrailers());
            this.setOnlyEmitsBuffer(from.onlyEmitsBuffer());
        }
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.isSet((byte)1);
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.isSet((byte)2);
    }

    @Override
    public boolean onlyEmitsBuffer() {
        return this.isSet((byte)4);
    }

    DefaultPayloadInfo setSafeToAggregate(boolean safeToAggregate) {
        return this.set((byte)1, safeToAggregate);
    }

    DefaultPayloadInfo setMayHaveTrailers(boolean mayHaveTrailers) {
        return this.set((byte)2, mayHaveTrailers);
    }

    DefaultPayloadInfo setOnlyEmitsBuffer(boolean onlyEmitsBuffer) {
        return this.set((byte)4, onlyEmitsBuffer);
    }

    static DefaultPayloadInfo forTransportReceive(HttpHeaders httpHeaders) {
        return DefaultPayloadInfo.newInfoUsingHeaders(httpHeaders);
    }

    static DefaultPayloadInfo forUserCreated(HttpHeaders httpHeaders) {
        return DefaultPayloadInfo.newInfoUsingHeaders(httpHeaders).setOnlyEmitsBuffer(true);
    }

    private static DefaultPayloadInfo newInfoUsingHeaders(HttpHeaders httpHeaders) {
        return HeaderUtils.isTransferEncodingChunked(httpHeaders) ? new DefaultPayloadInfo().setMayHaveTrailers(true) : new DefaultPayloadInfo();
    }

    private boolean isSet(byte expected) {
        return (this.flags & expected) == expected;
    }

    private DefaultPayloadInfo set(byte flag, boolean enabled) {
        this.flags = enabled ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPayloadInfo that = (DefaultPayloadInfo)o;
        return this.flags == that.flags;
    }

    public int hashCode() {
        return this.flags;
    }

    public String toString() {
        return "DefaultPayloadInfo{flags=" + this.flags + '}';
    }
}

