/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.CharSequences;
import io.servicetalk.http.api.DefaultHttpSerializationProvider;
import io.servicetalk.http.api.FormUrlEncodedHttpDeserializer;
import io.servicetalk.http.api.FormUrlEncodedHttpSerializer;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpSerializationProvider;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpStringDeserializer;
import io.servicetalk.http.api.HttpStringSerializer;
import io.servicetalk.serialization.api.DefaultSerializer;
import io.servicetalk.serialization.api.SerializationProvider;
import io.servicetalk.serialization.api.Serializer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class HttpSerializationProviders {
    private HttpSerializationProviders() {
    }

    public static HttpSerializer<Map<String, List<String>>> formUrlEncodedSerializer() {
        return FormUrlEncodedHttpSerializer.UTF8;
    }

    public static HttpSerializer<Map<String, List<String>>> formUrlEncodedSerializer(Charset charset) {
        CharSequence contentType = CharSequences.newAsciiString(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED + "; charset=" + charset.name());
        return HttpSerializationProviders.formUrlEncodedSerializer(charset, headers -> headers.set(HttpHeaderNames.CONTENT_TYPE, contentType));
    }

    public static HttpSerializer<Map<String, List<String>>> formUrlEncodedSerializer(Charset charset, Consumer<HttpHeaders> addContentType) {
        return new FormUrlEncodedHttpSerializer(charset, addContentType);
    }

    public static HttpDeserializer<Map<String, List<String>>> formUrlEncodedDeserializer() {
        return FormUrlEncodedHttpDeserializer.UTF8;
    }

    public static HttpDeserializer<Map<String, List<String>>> formUrlEncodedDeserializer(Charset charset) {
        return HttpSerializationProviders.formUrlEncodedDeserializer(charset, headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED, charset));
    }

    public static HttpDeserializer<Map<String, List<String>>> formUrlEncodedDeserializer(Charset charset, Predicate<HttpHeaders> checkContentType) {
        return new FormUrlEncodedHttpDeserializer(charset, checkContentType);
    }

    public static HttpSerializer<String> textSerializer() {
        return HttpStringSerializer.UTF8_STRING_SERIALIZER;
    }

    public static HttpSerializer<String> textSerializer(Charset charset) {
        return HttpSerializationProviders.textSerializer(charset, headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.TEXT_PLAIN, charset));
    }

    public static HttpSerializer<String> textSerializer(Charset charset, Consumer<HttpHeaders> addContentType) {
        return new HttpStringSerializer(charset, addContentType);
    }

    public static HttpDeserializer<String> textDeserializer() {
        return HttpStringDeserializer.UTF_8_STRING_DESERIALIZER;
    }

    public static HttpDeserializer<String> textDeserializer(Charset charset) {
        return HttpSerializationProviders.textDeserializer(charset, headers -> HeaderUtils.hasContentType(headers, HttpHeaderValues.TEXT_PLAIN, charset));
    }

    public static HttpDeserializer<String> textDeserializer(Charset charset, Predicate<HttpHeaders> checkContentType) {
        return new HttpStringDeserializer(charset, checkContentType);
    }

    public static HttpSerializationProvider jsonSerializer(Serializer serializer) {
        return HttpSerializationProviders.serializationProvider(serializer, (HttpHeaders headers) -> headers.set(HttpHeaderNames.CONTENT_TYPE, HttpHeaderValues.APPLICATION_JSON), (HttpHeaders headers) -> HeaderUtils.hasContentType(headers, HttpHeaderValues.APPLICATION_JSON, null));
    }

    public static HttpSerializationProvider jsonSerializer(SerializationProvider serializationProvider) {
        return HttpSerializationProviders.jsonSerializer((Serializer)new DefaultSerializer(serializationProvider));
    }

    public static HttpSerializationProvider serializationProvider(Serializer serializer, Consumer<HttpHeaders> addContentType, Predicate<HttpHeaders> checkContentType) {
        return new DefaultHttpSerializationProvider(serializer, addContentType, checkContentType);
    }

    public static HttpSerializationProvider serializationProvider(SerializationProvider serializationProvider, Consumer<HttpHeaders> addContentType, Predicate<HttpHeaders> checkContentType) {
        return HttpSerializationProviders.serializationProvider((Serializer)new DefaultSerializer(serializationProvider), addContentType, checkContentType);
    }
}

