/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.ServiceTalkTestTimeout;
import io.servicetalk.http.api.BlockingHttpRequester;
import io.servicetalk.http.api.DefaultHttpHeadersFactory;
import io.servicetalk.http.api.DefaultStreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.TestStreamingHttpClient;
import io.servicetalk.http.api.TestStreamingHttpConnection;
import io.servicetalk.transport.api.ConnectionContext;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=Parameterized.class)
public abstract class AbstractHttpRequesterFilterTest {
    private static final StreamingHttpRequestResponseFactory REQ_RES_FACTORY = new DefaultStreamingHttpRequestResponseFactory(BufferAllocators.DEFAULT_ALLOCATOR, DefaultHttpHeadersFactory.INSTANCE, HttpProtocolVersion.HTTP_1_1);
    @Rule
    public final MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public final Timeout timeout = new ServiceTalkTestTimeout();
    private final CompositeCloseable closeables = AsyncCloseables.newCompositeCloseable();
    public final RequesterType type;
    public final SecurityType security;
    @Mock
    private HttpExecutionContext mockExecutionContext;
    @Mock
    private ConnectionContext mockConnectionContext;

    public AbstractHttpRequesterFilterTest(RequesterType type, SecurityType security) {
        this.type = type;
        this.security = security;
    }

    @Parameterized.Parameters(name="{0}-{1}")
    public static Collection<Object[]> requesterTypes() {
        return Arrays.asList({RequesterType.Client, SecurityType.Secure}, {RequesterType.Client, SecurityType.Insecure}, {RequesterType.Connection, SecurityType.Secure}, {RequesterType.Connection, SecurityType.Insecure}, {RequesterType.ReservedConnection, SecurityType.Secure}, {RequesterType.ReservedConnection, SecurityType.Insecure});
    }

    @Before
    public final void setupContext() {
        Mockito.when((Object)this.mockConnectionContext.remoteAddress()).thenAnswer(__ -> this.remoteAddress());
        Mockito.when((Object)this.mockConnectionContext.localAddress()).thenAnswer(__ -> this.localAddress());
        Mockito.when((Object)this.mockConnectionContext.sslSession()).thenAnswer(__ -> {
            switch (this.security) {
                case Secure: {
                    return this.sslSession();
                }
            }
            return null;
        });
    }

    protected InetSocketAddress remoteAddress() {
        return InetSocketAddress.createUnresolved("127.0.1.1", 80);
    }

    protected InetSocketAddress localAddress() {
        return InetSocketAddress.createUnresolved("127.0.1.2", 28080);
    }

    protected SSLSession sslSession() {
        return (SSLSession)Mockito.mock(SSLSession.class);
    }

    protected Publisher<Object> loadbalancerEvents() {
        return Publisher.empty();
    }

    @After
    public final void closeClients() throws Exception {
        this.closeables.close();
    }

    protected final <FF extends StreamingHttpClientFilterFactory & StreamingHttpConnectionFilterFactory> StreamingHttpRequester createFilter(FF filterFactory) {
        return this.createFilter(RequestHandler.ok(), RequestWithContextHandler.ok(), filterFactory);
    }

    protected final <FF extends StreamingHttpClientFilterFactory & StreamingHttpConnectionFilterFactory> StreamingHttpRequester createFilter(RequestHandler rh, FF filterFactory) {
        return this.createFilter(rh, rh.withContext(), filterFactory);
    }

    protected final <FF extends StreamingHttpClientFilterFactory & StreamingHttpConnectionFilterFactory> StreamingHttpRequester createFilter(RequestHandler rh, RequestWithContextHandler rwch, FF filterFactory) {
        switch (this.type) {
            case Client: {
                return (StreamingHttpRequester)this.closeables.prepend((AsyncCloseable)this.newClient(rh, rwch, filterFactory));
            }
            case Connection: {
                return (StreamingHttpRequester)this.closeables.prepend((AsyncCloseable)this.newConnection(rwch, filterFactory));
            }
            case ReservedConnection: {
                try {
                    return (StreamingHttpRequester)((StreamingHttpClient)this.closeables.prepend((AsyncCloseable)this.newClient(rh, rwch, filterFactory))).reserveConnection((HttpRequestMetaData)REQ_RES_FACTORY.get("")).toFuture().get();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalArgumentException(this.type.name());
    }

    protected BlockingHttpRequester asBlockingRequester(StreamingHttpRequester requester) {
        if (requester instanceof StreamingHttpClient) {
            return ((StreamingHttpClient)requester).asBlockingClient();
        }
        return ((StreamingHttpConnection)requester).asBlockingConnection();
    }

    private ReservedStreamingHttpConnection newReservedConnection() {
        final StreamingHttpConnection connection = this.newConnection(RequestWithContextHandler.ok(), null);
        return new ReservedStreamingHttpConnection(){

            public ReservedHttpConnection asConnection() {
                throw new UnsupportedOperationException();
            }

            public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
                throw new UnsupportedOperationException();
            }

            public ReservedBlockingHttpConnection asBlockingConnection() {
                throw new UnsupportedOperationException();
            }

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return connection.newRequest(method, requestTarget);
            }

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return connection.request(request);
            }

            public Completable closeAsync() {
                return connection.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return connection.closeAsyncGracefully();
            }

            public Completable onClose() {
                return connection.onClose();
            }

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return connection.request(strategy, request);
            }

            public HttpExecutionContext executionContext() {
                return connection.executionContext();
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return connection.httpResponseFactory();
            }

            public void close() throws Exception {
                connection.close();
            }

            public ConnectionContext connectionContext() {
                return connection.connectionContext();
            }

            public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
                return connection.transportEventStream(eventKey);
            }

            public Completable releaseAsync() {
                return Completable.completed();
            }
        };
    }

    private StreamingHttpConnection newConnection(final RequestWithContextHandler rwch, @Nullable StreamingHttpConnectionFilterFactory filterFactory) {
        StreamingHttpConnectionFilterFactory handlerFilter = conn -> new StreamingHttpConnectionFilter(conn){

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return rwch.request((StreamingHttpResponseFactory)REQ_RES_FACTORY, this.connectionContext(), request);
            }
        };
        return TestStreamingHttpConnection.from(REQ_RES_FACTORY, this.mockExecutionContext, this.mockConnectionContext, filterFactory == null ? handlerFilter : filterFactory.append(handlerFilter));
    }

    private <FF extends StreamingHttpClientFilterFactory & StreamingHttpConnectionFilterFactory> StreamingHttpClient newClient(final RequestHandler rh, final RequestWithContextHandler rwch, FF filterFactory) {
        StreamingHttpClientFilterFactory handlerFilter = client -> new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return rh.request((StreamingHttpResponseFactory)REQ_RES_FACTORY, request);
            }

            public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpExecutionStrategy strategy, HttpRequestMetaData metaData) {
                return Single.succeeded((Object)AbstractHttpRequesterFilterTest.this.newReservedConnection()).map(rc -> new ReservedStreamingHttpConnectionFilter((FilterableReservedStreamingHttpConnection)rc){

                    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                        return rwch.request(delegate.httpResponseFactory(), this.connectionContext(), request);
                    }
                });
            }
        };
        return TestStreamingHttpClient.from(REQ_RES_FACTORY, this.mockExecutionContext, filterFactory.append(handlerFilter));
    }

    @FunctionalInterface
    public static interface RequestWithContextHandler {
        public Single<StreamingHttpResponse> request(StreamingHttpResponseFactory var1, ConnectionContext var2, StreamingHttpRequest var3);

        public static RequestWithContextHandler ok() {
            return (respFactory, context, request) -> Single.succeeded((Object)REQ_RES_FACTORY.ok());
        }
    }

    @FunctionalInterface
    public static interface RequestHandler {
        public Single<StreamingHttpResponse> request(StreamingHttpResponseFactory var1, StreamingHttpRequest var2);

        public static RequestHandler ok() {
            return (respFactory, request) -> Single.succeeded((Object)REQ_RES_FACTORY.ok());
        }

        default public RequestWithContextHandler withContext() {
            return (respFactory, context, request) -> this.request(respFactory, request);
        }
    }

    public static enum RequesterType {
        Client,
        Connection,
        ReservedConnection;

    }

    public static enum SecurityType {
        Secure,
        Insecure;

    }
}

