/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.DelegatingHttpExecutionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpRequestResponseFactory;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseFactory;
import io.servicetalk.http.api.RequestResponseFactories;
import io.servicetalk.http.api.StreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.DelegatingConnectionContext;
import io.servicetalk.transport.api.ExecutionContext;

final class StreamingHttpConnectionToBlockingHttpConnection
implements BlockingHttpConnection {
    static final HttpExecutionStrategy DEFAULT_BLOCKING_CONNECTION_STRATEGY = HttpExecutionStrategies.OFFLOAD_NONE_STRATEGY;
    private final StreamingHttpConnection connection;
    private final HttpExecutionStrategy strategy;
    private final ConnectionContext context;
    private final HttpExecutionContext executionContext;
    private final HttpRequestResponseFactory reqRespFactory;

    StreamingHttpConnectionToBlockingHttpConnection(StreamingHttpConnection connection, HttpExecutionStrategyInfluencer influencer) {
        this.strategy = influencer.influenceStrategy(DEFAULT_BLOCKING_CONNECTION_STRATEGY);
        this.connection = connection;
        ConnectionContext originalCtx = connection.connectionContext();
        this.executionContext = new DelegatingHttpExecutionContext(connection.executionContext()){

            @Override
            public HttpExecutionStrategy executionStrategy() {
                return StreamingHttpConnectionToBlockingHttpConnection.this.strategy;
            }
        };
        this.context = new DelegatingConnectionContext(originalCtx){

            public ExecutionContext executionContext() {
                return StreamingHttpConnectionToBlockingHttpConnection.this.executionContext;
            }
        };
        this.reqRespFactory = RequestResponseFactories.toAggregated(connection);
    }

    @Override
    public HttpResponse request(HttpRequest request) throws Exception {
        return this.request(this.strategy, request);
    }

    @Override
    public ConnectionContext connectionContext() {
        return this.context;
    }

    @Override
    public <T> BlockingIterable<? extends T> transportEventIterable(HttpEventKey<T> eventKey) {
        return this.connection.transportEventStream(eventKey).toIterable();
    }

    @Override
    public StreamingHttpConnection asStreamingConnection() {
        return this.connection;
    }

    @Override
    public HttpResponse request(HttpExecutionStrategy strategy, HttpRequest request) throws Exception {
        return BlockingUtils.request((StreamingHttpRequester)this.connection, strategy, request);
    }

    @Override
    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public HttpResponseFactory httpResponseFactory() {
        return this.reqRespFactory;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    public void closeGracefully() throws Exception {
        this.connection.closeGracefully();
    }

    @Override
    public HttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.reqRespFactory.newRequest(method, requestTarget);
    }
}

