/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.AsciiBuffer;

final class NetUtils {
    private NetUtils() {
    }

    static boolean isValidIpV4Address(CharSequence ip) {
        return NetUtils.isValidIpV4Address(ip, 0, ip.length());
    }

    private static boolean isValidIpV4Address(CharSequence ip, int from, int toExclusive) {
        return ip instanceof String ? NetUtils.isValidIpV4Address((String)ip, from, toExclusive, String::indexOf) : (ip instanceof AsciiBuffer ? NetUtils.isValidIpV4Address((AsciiBuffer)ip, from, toExclusive, AsciiBuffer::indexOf) : NetUtils.isValidIpV4Address(ip, from, toExclusive, NetUtils::indexOf0));
    }

    private static <T extends CharSequence> boolean isValidIpV4Address(T ip, int from, int toExcluded, IndexOfExtractor<T> extractor) {
        int i;
        int len = toExcluded - from;
        return len <= 15 && len >= 7 && (i = extractor.indexOf(ip, '.', from + 1)) > 0 && NetUtils.isValidIpV4Word(ip, from, i) && (i = extractor.indexOf(ip, '.', from = i + 2)) > 0 && NetUtils.isValidIpV4Word(ip, from - 1, i) && (i = extractor.indexOf(ip, '.', from = i + 2)) > 0 && NetUtils.isValidIpV4Word(ip, from - 1, i) && NetUtils.isValidIpV4Word(ip, i + 1, toExcluded);
    }

    static boolean isValidIpV6Address(CharSequence ip) {
        int compressBegin;
        int colons;
        int start;
        int end = ip.length();
        if (end < 2) {
            return false;
        }
        char c = ip.charAt(0);
        if (c == '[') {
            if (ip.charAt(--end) != ']') {
                return false;
            }
            start = 1;
            c = ip.charAt(1);
        } else {
            start = 0;
        }
        if (c == ':') {
            if (ip.charAt(start + 1) != ':') {
                return false;
            }
            colons = 2;
            compressBegin = start;
            start += 2;
        } else {
            colons = 0;
            compressBegin = -1;
        }
        int wordLen = 0;
        block5: for (int i = start; i < end; ++i) {
            c = ip.charAt(i);
            if (NetUtils.isValidHexChar(c)) {
                if (wordLen < 4) {
                    ++wordLen;
                    continue;
                }
                return false;
            }
            switch (c) {
                case ':': {
                    if (colons > 7) {
                        return false;
                    }
                    if (ip.charAt(i - 1) == ':') {
                        if (compressBegin >= 0) {
                            return false;
                        }
                        compressBegin = i - 1;
                    } else {
                        wordLen = 0;
                    }
                    ++colons;
                    continue block5;
                }
                case '.': {
                    if (compressBegin < 0 && colons != 6 || colons == 7 && compressBegin >= start || colons > 7) {
                        return false;
                    }
                    int ipv4Start = i - wordLen;
                    int j = ipv4Start - 2;
                    if (NetUtils.isValidIPv4MappedChar(ip.charAt(j))) {
                        if (!(NetUtils.isValidIPv4MappedChar(ip.charAt(j - 1)) && NetUtils.isValidIPv4MappedChar(ip.charAt(j - 2)) && NetUtils.isValidIPv4MappedChar(ip.charAt(j - 3)))) {
                            return false;
                        }
                        j -= 5;
                    }
                    while (j >= start) {
                        char tmpChar = ip.charAt(j);
                        if (tmpChar != '0' && tmpChar != ':') {
                            return false;
                        }
                        --j;
                    }
                    int ipv4End = NetUtils.indexOf(ip, '%', ipv4Start + 7);
                    if (ipv4End < 0) {
                        ipv4End = end;
                    }
                    return NetUtils.isValidIpV4Address(ip, ipv4Start, ipv4End);
                }
                case '%': {
                    end = i;
                    break block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (compressBegin < 0) {
            return colons == 7 && wordLen > 0;
        }
        return compressBegin + 2 == end || wordLen > 0 && (colons < 8 || compressBegin <= start);
    }

    private static boolean isValidIpV4Word(CharSequence word, int from, int toExclusive) {
        char c0;
        int len = toExclusive - from;
        if (len < 1 || len > 3 || (c0 = word.charAt(from)) < '0') {
            return false;
        }
        if (len == 3) {
            char c2;
            char c1 = word.charAt(from + 1);
            return c1 >= '0' && (c2 = word.charAt(from + 2)) >= '0' && (c0 <= '1' && c1 <= '9' && c2 <= '9' || c0 == '2' && c1 <= '5' && (c2 <= '5' || c1 < '5' && c2 <= '9'));
        }
        return c0 <= '9' && (len == 1 || NetUtils.isValidNumericChar(word.charAt(from + 1)));
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isValidIPv4MappedChar(char c) {
        return c == 'f' || c == 'F';
    }

    private static int indexOf(CharSequence cs, char searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        if (cs instanceof AsciiBuffer) {
            return ((AsciiBuffer)cs).indexOf(searchChar, start);
        }
        return NetUtils.indexOf0(cs, searchChar, start);
    }

    private static int indexOf0(CharSequence cs, char searchChar, int start) {
        int i;
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        int n = i = start < 0 ? 0 : start;
        while (i < sz) {
            if (cs.charAt(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @FunctionalInterface
    private static interface IndexOfExtractor<T extends CharSequence> {
        public int indexOf(T var1, char var2, int var3);
    }
}

