/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.function.BiFunction;

public interface HttpMetaData {
    public HttpProtocolVersion version();

    public HttpMetaData version(HttpProtocolVersion var1);

    public HttpHeaders headers();

    default public HttpMetaData addHeader(CharSequence name, CharSequence value) {
        this.headers().add(name, value);
        return this;
    }

    default public HttpMetaData addHeaders(HttpHeaders headers) {
        this.headers().add(headers);
        return this;
    }

    default public HttpMetaData setHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    default public HttpMetaData setHeaders(HttpHeaders headers) {
        this.headers().set(headers);
        return this;
    }

    default public HttpMetaData addCookie(HttpCookiePair cookie) {
        this.headers().addCookie(cookie);
        return this;
    }

    default public HttpMetaData addCookie(CharSequence name, CharSequence value) {
        this.headers().addCookie(name, value);
        return this;
    }

    default public HttpMetaData addSetCookie(HttpSetCookie cookie) {
        this.headers().addSetCookie(cookie);
        return this;
    }

    default public HttpMetaData addSetCookie(CharSequence name, CharSequence value) {
        this.headers().addSetCookie(name, value);
        return this;
    }

    public String toString();

    default public String toString(BiFunction<? super CharSequence, ? super CharSequence, CharSequence> headerFilter) {
        return this.toString() + System.lineSeparator() + this.headers().toString(headerFilter);
    }
}

