/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.AbstractServiceAdapterHolder;
import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingUtils;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import java.util.Objects;

final class BlockingToStreamingService
extends AbstractServiceAdapterHolder {
    static final HttpExecutionStrategy DEFAULT_STRATEGY = HttpExecutionStrategies.OFFLOAD_RECEIVE_DATA_STRATEGY;
    private final BlockingHttpService original;

    BlockingToStreamingService(BlockingHttpService original, HttpExecutionStrategyInfluencer influencer) {
        super(influencer.influenceStrategy(DEFAULT_STRATEGY));
        this.original = Objects.requireNonNull(original);
    }

    @Override
    public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
        return request.toRequest().flatMap(req -> BlockingUtils.blockingToSingle(() -> this.original.handle(ctx, (HttpRequest)req, ctx.responseFactory())).map(HttpResponse::toStreamingResponse));
    }

    @Override
    public Completable closeAsync() {
        return BlockingUtils.blockingToCompletable(this.original::close);
    }
}

