/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpConnection;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.transport.api.ConnectionContext;

public final class TestStreamingHttpConnection {
    private TestStreamingHttpConnection() {
    }

    public static StreamingHttpConnection from(final StreamingHttpRequestResponseFactory reqRespFactory, final HttpExecutionContext executionContext, final ConnectionContext connectionContext, StreamingHttpConnectionFilterFactory factory) {
        StreamingHttpConnectionFilter filterChain = factory.create(new FilterableStreamingHttpConnection(){
            private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }

            public Completable onClose() {
                return this.closeable.onClose();
            }

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return Single.failed((Throwable)new UnsupportedOperationException());
            }

            public HttpExecutionContext executionContext() {
                return executionContext;
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return reqRespFactory;
            }

            public ConnectionContext connectionContext() {
                return connectionContext;
            }

            public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
                return Publisher.failed((Throwable)new UnsupportedOperationException());
            }

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return reqRespFactory.newRequest(method, requestTarget);
            }
        });
        return TestStreamingHttpConnection.from((FilterableStreamingHttpConnection)filterChain);
    }

    public static StreamingHttpConnection from(final FilterableStreamingHttpConnection filterChain) {
        return new StreamingHttpConnection(){

            public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                return filterChain.newRequest(method, requestTarget);
            }

            public Completable closeAsync() {
                return filterChain.closeAsync();
            }

            public Completable closeAsyncGracefully() {
                return filterChain.closeAsyncGracefully();
            }

            public Completable onClose() {
                return filterChain.onClose();
            }

            public Single<StreamingHttpResponse> request(HttpExecutionStrategy strategy, StreamingHttpRequest request) {
                return filterChain.request(strategy, request);
            }

            public HttpExecutionContext executionContext() {
                return filterChain.executionContext();
            }

            public StreamingHttpResponseFactory httpResponseFactory() {
                return filterChain.httpResponseFactory();
            }

            public ConnectionContext connectionContext() {
                return filterChain.connectionContext();
            }

            public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
                return filterChain.transportEventStream(eventKey);
            }

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return filterChain.request(HttpExecutionStrategies.defaultStrategy(), request);
            }

            public HttpConnection asConnection() {
                return HttpApiConversions.toConnection((StreamingHttpConnection)this, strategy -> strategy);
            }

            public BlockingStreamingHttpConnection asBlockingStreamingConnection() {
                return HttpApiConversions.toBlockingStreamingConnection((StreamingHttpConnection)this, strategy -> strategy);
            }

            public BlockingHttpConnection asBlockingConnection() {
                return HttpApiConversions.toBlockingConnection((StreamingHttpConnection)this, strategy -> strategy);
            }
        };
    }
}

